function pi5write(img, filename)
%
% PI5WRITE Write a modified PGM-P5 (Portable Gray Map image) file to disk.
%   PI5WRITE(X,'filename') writes a modified PGM-P5 file containing the
%   image X to a disk file called 'filename'.
%   PI5 is stores unsigned integers (2 bytes / pixel) instead
%   of unsigned chars.
%
%   See also: PI5READ

% 9/9/98, 1/10/98(PI5) J.Gaspar

fid= fopen(filename,'w');
if fid<0,
  error(['Opening output file: ' filename]);
end

header= ['PI5' 10 num2str(size(img,2)) ' ' num2str(size(img,1))];
header= [header 10 '65000' 10];

fwrite(fid, header, 'uchar');

fwrite(fid, img', 'ushort');

fclose(fid);
