function img= p5read(filename)
%
% P5READ Read a PGM-P5 (Portable Gray Map image) file from disk.
%        X=P5READ('filename') reads the file 'filename' and returns
%        the image X.
%
%        See also: P5WRITE

% 9/9/98, J.Gaspar

fid= fopen(filename,'r');
if fid<0,
  error(['Opening input file: ' filename]);
end

p5= fread(fid,2,'uchar');
p5= char(p5);
if (upper(p5') ~= ['P5'] ),
  error(['not P5 the first two characters of image file:' filename]);
end

nCols= p5readti(fid);
nLins= p5readti(fid);
maxV=  p5readti(fid);  % this value is ignored

img= fread(fid, [nCols nLins], 'uchar')';

fclose(fid);
