function finish
% Code to run before leaving the Matlab session

% When MATLAB exits, it runs the script finish.m, if the file exists 
%   in the current folder or anywhere on the search path
% https://www.mathworks.com/help/matlab/matlab_env/exit-matlab-.html

% Oct2019, Oct2020 (cmts++), JG

% disp('** press return to end...');
% pause

% in case you have "matlab.my\." do not close the editor
if exist('matlab.my', 'dir')
    return
end

% goto a default folder
cd( [fileparts(which('login_controlo.m')) filesep '..' filesep '..'] )

% close the editor
MLEditorServices = com.mathworks.mlservices.MLEditorServices;
MLEditor = MLEditorServices.getEditorApplication;
MLEditor.close();
