function zero_use_for_calibration
%
% Strain Gauge - compute offset correction to apply before the gain K_GAGE
%
% Let x=ADC, x0=strain_gauge_offset, k0=strain_gauge_gain_after_offset
% g= K*k0*(x-x0)
% x0= g/K/k0-g

% April 2016, JG

flg1= evalin('base',['exist(''K_GAGE'',''var'')']);
flg2= evalin('base',['exist(''zero_g'',''var'')']);
if ~flg1 | ~flg2
    error('missing vars, please run "setup_ceelab.m" and "zero_*.mdl"')
end

g= evalin('base', 'median(zero_g(:,2))');
K= evalin('base', 'K_GAGE');

x0= g/K/1.0-g;

assignin('base', 'strain_gauge_offset', x0);
assignin('base', 'strain_gauge_gain_after_offset', 1.0); % do nothing
