
% ############### USER-DEFINED SRV02 CONFIGURATION ######################################
% External Gear Configuration: set to 'HIGH' or 'LOW'
EXT_GEAR_CONFIG = 'HIGH';
% Encoder Type: set to 'E' or 'EHR'
ENCODER_TYPE = 'E';
% Is the SRV02 equipped with a Tachometer? (i.e. option T): set to 'YES' or 'NO'
TACH_OPTION = 'NO';
% Universal Power Module (UPM) Type: set to 'UPM_2405', 'UPM_1503', or 'UPM_1503x2'
UPM_TYPE = 'UPM_2405';
% Type of Load: set to 'NO_LOAD', 'DISC_LOAD', 'BAR_LOAD', 'SLIP_RING', 'ROTFLEX' or 'FLEXGAGE' 
LOAD_TYPE = 'FLEXGAGE';
% Cable Gain used: set to 1, 3 or 5
K_CABLE = 1;
% ############### END OF USER-DEFINED SRV02 CONFIGURATION ###############################

% Set Model Variables Accordingly to the USER-DEFINED SRV02 System Configuration
% Also Calculate the SRV02 Model Parameters and 
% Write them to the MATLAB Workspace (to be used in Simulink diagrams)
[ Rm, Kt, Km, Kg, Eff_G, Beq, Jeq, Eff_M ] = Set_SRV02_Configuration ( EXT_GEAR_CONFIG, ENCODER_TYPE, TACH_OPTION, UPM_TYPE,LOAD_TYPE );

% Set Model Variables Accordingly to the USER-DEFINED ROTARY FLEXIBLE JOINT System Configuration
[ A, B, C, D ] = Set_Link_Configuration ( Rm, Kt, Km, Kg, Eff_G, Beq, Jeq, Eff_M );

C = [1 1 0 0];

% Define which Global Variables will be required in Simulink diagrams
global K_POT K_TACH K_ENC VMAX_UPM IMAX_UPM K_GAGE

ts = 0.001;
csipf = 1;
wnpf = 7;