% This function sets all the required parameters and state-space representation of the 
% SRV02 Flexible Link System

function [ A, B, C, D ] = Set_Joint_Configuration ( Rm, Kt, Km, Kg, Eff_G, Beq, Jeq, Eff_M )

global K_GAGE

Link_L = 0.0254 * 15; % Length of the Link is 15 inches
Link_M = 0.065; % 65 grams
Wc = 2 * pi * 3; % Natural Frequency was experimentally determined to be 3 Hz
K_GAGE = 1 / 19;

Jarm = Link_M * Link_L ^ 2 / 3; % Calculte the Moment of Inertia of a Link (Assumed Rigid)
K_Stiff = Wc^2 * Jarm; % Estimate the Stiffness of the simplified Link Model

eqn_SRV02_Flexible_Link; 
% This script was generated by Maple. It will take the above parameters and generate the 
% State Space representation of the SRV02 Flexible Link System.