function login_z_install
%
% Put into the matlab the path of the folder containing login_z_install.m
%
% Runing this once, allows other scripts/functions in the same folder to
% run whenever called in future Matlab sessions.

% TODO: create login_z_data.m returning a structure with relevant data

% 2015.03.12, March2017 (file renamed), J.Gaspar


% define what should be in the path :

fname= 'login_z_install.m';
p= which(fname);
p= strrep(p, fname, '');
p= p(1:end-1);

if 0
    %
    % [OLD ver] put p into matlabrc, if not there yet :
    %
    str= ['path(path,''' p ''');'];
    fname= which('matlabrc.m');
    if ~str_in_file(fname, str)
        str_append_to_file(fname, str);
        fprintf(1, '-- Modified "matlabrc.m".\n');
    else
        fprintf(1, '-- Nothing to do.\n');
    end
else
    %
    % [new ver] ask Matlab to handle the Microsoft Windows VirtualStore
    %
    if isempty(strfind(path,p))
        path(path, p);
        savepath
        fprintf(1, '-- Path saved.\n');
    else
        fprintf(1, '-- Nothing to do.\n');
    end
end

return; % end of main function


% ------------------------------------
function flag= str_in_file(fname, str)
% To use in the future: check startup.m has the right path
flag= 0;
fid=fopen(fname);
while 1
    tline = fgetl(fid);
    if ~ischar(tline),   break,   end
    if strcmp(tline, str)
        flag=1; break;
    end
end
fclose(fid);


% ------------------------------------
function str_append_to_file(fname, str)
fid=fopen(fname, 'at');
fprintf(fid, '%s\n', str);
fclose(fid);
