function login_cee(pathIniOnly)
%
% CMNO 2022/2023
%  Funo que cria / muda para a directoria de trabalho.
%

% 13.3.2013, 6.4.2016 (Matlab2015a), JG

if nargin<1,
    pathIniOnly=0;
end
update_cee_files

% ask group name
%
s= ask_group_name( pathIniOnly );

% save group name in a global variable
global login_cee_grp
login_cee_grp= s;

% mostra nome do grupo
sh_group(s)

% inicializa utilitarios
path_ini

% muda para a directoria de trabalho
goto_dir(s)

% distribui cpias de ficheiros necessrios
login_z_copy_files

return; % end of function


% --------------------------- aux fn:
%
function login_grp = ask_group_name( pathIniOnly )
if isnumeric(pathIniOnly) && (pathIniOnly==-1)
    %   add path but do not change current folder
    path_ini;
    login_grp= 'a1';
    return;
end

% pergunta e verifica nome de grupo
%
s= [];
if ischar(pathIniOnly)
    s= pathIniOnly;
    s= verify_name(s);
end
while isempty(s),
    s= input('-- Qual o V/ grupo? [return mostra lista] ', 's');
    if isempty(s),
        helpwin('login_cee_grupos')
    else
        s= verify_name(s);
    end
    fprintf(1,'\n')
end
login_grp= s;


% --------------------------- aux fn:
%
function path_ini(ask_HW_or_SW)
%
%  Junta ao path actual subdirectorias necessarias
%
if nargin<1, ask_HW_or_SW=0; end

p= which('login_cee'); p= strrep(lower(p), 'login_cee.m', '');

%path(path, [p 'sys1_flexbar']);
%path(path, [p 'sys2_pendulo_v0']);
path(path, [p 'sys2_pendulum']);
path(path, [p 'util']);


% --------------------------- aux fn:
%
function goto_dir(grupo)
%
% muda para a directoria indicada
% pelo nome do grupo
%
% grupo: str

b= 'c:\'; d= 'users2';
if ~exist([b d], 'dir'), mkdir(b,d); end

b= [b d '\']; d= 'CMNO22';
if ~exist([b d], 'dir'), mkdir(b,d); end

b= [b d '\']; d= grupo;
if ~exist([b d], 'dir'), mkdir(b,d); end

cd([b d]);
disp(['-- Directoria corrente: ' pwd]);
fprintf(1,'\n');
return


% --------------------------- aux fn:
%
function s2= verify_name(s0)
%
% verify that s has the struct yz with
%  y in a..d
%  z in 1..8
% string 'tmp' is also valid
%
% s0: str : group name assumed to be in the DB
% s2: str : s2=s0 if s0 is in DB, otherwise s2=[]
%
s= lower(s0);
s2= [];
if strncmpi(s,'tmp',3), s2='tmp'; return; end;

% if length(s)~=2,
%     %
%     disp(['** Nome de grupo invlido: ' s])
%     disp( '   Nome do grupo dever ter 2 caracteres.')
%     return;
% end
% if s(1)<'a' | 'e' < s(1),
%     disp(['** Nome de grupo invlido: ' s])
%     disp( '   O 1 caracter do nome do grupo deve estar entre "a" e "e".')
%     return;
% end
% if s(2)<'1' | '8'<s(2),
%     disp(['** Nome de grupo invlido: ' s])
%     disp( '   O 2 caracter do nome do grupo deve ser a, b ou c.')
%     return;
% end
% s2= s;

if length(s)<1
    error('Group name length less than 1');
end
if min( ('0'<=s) & (s<='9') ) == 1
    % given just a number
    gnum= str2num(s);
elseif lower(s(1))=='g' && length(s)>1
    % given string "gN" or "gNN"
    gnum= str2num(s(2:end));
else
    error('Group name expected "gNN", while you wrote: %s', s);
end
if gnum<1 || 32<gnum
    error('Group number out of [1, 28]')
end
s2= sprintf('g%02d', gnum);


% --------------------------- aux fn:
%
function sh_group(str)
%
% find and display group "str"
%
fid=fopen('login_cee_grupos.m','rt');
if fid<1
    error('file open failed')
end
while 1
    tline = fgetl(fid);
    if ~ischar(tline), break, end
    if ~isempty(findstr(upper(tline),upper(str))),
        s0= [' --- ' tline(2:end)];
        fprintf(1,'\n%s\n', get_group(fid, s0));
        fclose(fid);
        fprintf(1,' ---  se o grupo nao estiver correcto, repita login (>> login_cee)\n\n');
        return; % successful return
    end
end
fprintf(1, '\n  *** O grupo "%s" nao existe na lista de grupos. Repetir login >> login_cee\n\n', str);
fclose(fid);


function str= get_group(fid, s0)
%
str=s0;
for i=1:4,
    tline = fgetl(fid);
    if ~ischar(tline), break, end
    str= sprintf('%s\n\t\t%s', str, tline(2:end));
end
