function [t2,y2,indSav]= my_sparse_digital_plot(t, y, options)
%
% Input:
% t: Nx1
% y: Nx1 or NxM
% options: struct : e.g. "nPtsForThreshold"
%
% Output:
% t: N2x1
% y: N2x1 or N2xM
% indSav

if nargin<3
    options= [];
end
if size(t,2)~=1
    error('size(t) must be Nx1');
end
if size(y,1)<size(y,2)
    error('size(y) must be Nx1 or NxM (with M<<N)');
end

[t2,y2,indSav]= my_sparse_digital_plot_main(t, y, options);

return; % end of main function


function [t2,y2,indSav]= my_sparse_digital_plot_main(t, y, options)
%
% find 0->1 and 1->0 transitions
%
indSav= find( sum( abs(diff(y,[],1))>0 , 2) > 0 );
indSav= [indSav(:)'; indSav(:)'+1];
indSav= indSav(:);
if isempty(indSav) || indSav(1)~=1, indSav= [1; indSav]; end
if indSav(end)~=length(t), indSav(end+1)= length(t); end

t2= t(indSav);
y2= y(indSav,:);
