function plot_z_demo( demoId )
% Demo of "plot_z.m"
% Nov16, Jose Gaspar

if nargin<1
    demoId= 2; % 1:4;
end
for i= demoId
    plot_z_demo_main( i );
    %pause
end

return; % end of main function


function plot_z_demo_main( demoId )
switch demoId
    case 1
        % direct plot of random data
        [t, y]= mk_data1;

        figure(201); clf
        plot_z( t, y );
        
    case {2, 3, 4}
        if demoId==2
            % plot random digital data subsampled to 500 points
            [t2, y2]= mk_data2;
        elseif demoId==3
            % plot random analog data (200 points)
            [t2, y2]= mk_data3;
        else
            % plot random analog data subsampled to 500 points
            [t2, y2]= mk_data3( 5000 );
        end

        figure(201); clf
        plot_z( t2, y2 );
        %plot_z( t2, y2, struct('multicolor',1) );

        figure(202); clf
        plot_z( t2, y2, struct('plot3',1) );

        figure(203); clf
        plot_z( t2, y2, struct('patch',1) );
        
    otherwise
        error('inv demoId')
end


function [t, y]= mk_data1
% Create random digital data (1000 points)
%
t= (1:1000)';
%y= (rand(5,length(t))>0.5)';
y= (conv2(rand(5,length(t)),ones(1,30)/30,'same')>0.5)'; % digital smoothed


function [t2, y2]= mk_data2
% Reduce the amount of digital data (reduce to 500 points)
%
[t, y]= mk_data1;
[t2, y2]= my_sparse_plot(t, y);


function [t2, y2]= mk_data3( nPoints )
% Create random analog data (# points = nPoints)
%
if nargin<1, nPoints=200; end
t= (1:nPoints)';
y= (conv2(randn(5,length(t)),ones(1,30)/30,'same'))'; % digital smoothed

% reduce max number of points to 500
[t2, y2]= my_sparse_plot(t, y);
