function [t2,y2ab,indSav]= my_sparse_plot_maxmin(t, y, options)
%
% t: Nx1 or 1xN
% y: Nx1 or 1xN
%
% t2: N2x1
% y2ab: N2x2

if nargin<3
    options= [];
end

N2= 500;
if isfield(options, 'nPtsForThreshold'), N2= options.nPtsForThreshold; end

if length(t)<=N2
    t2= t(:);
    y2= repmat(y(:),1,2);
    indSav= 1:length(t);
    return
end

N= length(t);
indSav= round(1:N/N2:N);
if indSav(end)~=N, indSav(end+1)=N; end
N2= length(indSav);

% compute time samples and pre-allocate output
t2= t(indSav);
t2= reshape(t2, [length(t2) 1]);
y2ab= zeros(size(t2,1), 2);

% compute max & min foreach interval
for i= 1:length(indSav)-1
    y2ab(i,1)= max(y(indSav(i):indSav(i+1)));
    y2ab(i,2)= min(y(indSav(i):indSav(i+1)));
end
y2ab(end,1)= y(end);
y2ab(end,2)= y(end);

if isfield(options, 'oneLineMaxMin')
    t2= [t2(:)  t2(:)]';  t2= t2(:);
    y2ab= y2ab(:);
end

% try to match input, if t and y have equal sizes
% ( e.g. do nothing if size(y)==size(t') )
%
if size(t,1)==size(y,1) && size(t,2)==size(y,2)
    % if input are horizontal vectors, then transpose
    if size(t,1)<size(t,2); t2= t2'; y2ab= y2ab'; end
end
