function [t2,y2,indSav]= my_sparse_plot(t, y, options)
% Convert dense plots into sparser plots, allowing to save smaller print
% files.
% Two main algorithms: y multi-dimensional or y mono-dimensional
% Mono-dim options: "addLocalExtrema"
%
% Input:
% t: Nx1
% y: Nx1 or NxM
% options: struct : e.g. "nPtsForThreshold"
%
% Output:
% t: N2x1
% y: N2x1 or N2xM
% indSav

% Feb2015, JG

if nargin<3
    options= [];
end

if isstruct(t) || (size(y,1)>1 && size(y,2)>1)
    % t is a struct (x1) and y contains a list of fieldnames
    % or t is Nx1 and y is NxM
    [t2,y2,indSav]= my_sparse_plot_ndim(t, y, options);
else
    % t is Nx1 and y is Nx1
    % i.e. if size(y,1)==1 || size(y,2)==1
    [t2,y2,indSav]= my_sparse_plot_1dim(t, y, options);
end

return; % end of main function


% -----------------------------------------------------------------------
function [t2,y2,indSav]= my_sparse_plot_1dim(t, y, options)

% main idea: limit dt and dy

addLocalExtrema= 0;
if isfield(options, 'addLocalExtrema'), addLocalExtrema= options.addLocalExtrema; end
nPtsForThreshold= 500;
if isfield(options, 'nPtsForThreshold'), nPtsForThreshold= options.nPtsForThreshold; end

ind= 1;
indSav= ind;
N= length(t);

% calc thresholds
% max 400 pts horiz and vertically
thres_t= (max(t)-min(t))/nPtsForThreshold; %500; %400;
thres_y= (max(y)-min(y))/nPtsForThreshold; %500; %400;
if thres_y<eps
    thres_y= thres_y+inf; % ignore thres_y
end

% calc subsampling
lastt= t(indSav(end)); % indSav(end) == 1
lasty= y(indSav(end)); % indSav(end) == 1
ind= 2;
lastmin= +inf; ind1a= 1;
lastmax= -inf; ind1b= 1;
while ind<N
    if y(ind)<lastmin, lastmin= y(ind); ind1a=ind; end
    if y(ind)>lastmax, lastmax= y(ind); ind1b=ind; end
    if abs(t(ind)-lastt) >= thres_t || abs(y(ind)-lasty) >= thres_y
        if addLocalExtrema
            %             ind0= indSav(end); % ind is a candidate
            %             if y(ind0)>y(ind)
            %                 % gowing down; did pass a local max?
            %                 [ymax,ind1]= max(y(ind0:ind));
            %                 if ymax > y(ind0)
            %                     ind= ind1; % go back
            %                 end
            %             else
            %                 % gowing up; did pass a local min?
            %                 [ymin,ind1]= min(y(ind0:ind));
            %                 if ymin < y(ind0)
            %                     ind= ind1; % go back
            %                 end
            %             end
            %
            %             if  y(ind) < y(indSav(end))  &&  ind1b > indSav(end)
            %                 % gowing down and did pass a local max
            %                 ind=ind1b;
            %             elseif y(ind) > y(indSav(end))  &&  ind1a > indSav(end)
            %                 % gowing up and did pass a local min
            %                 ind=ind1a;
            %             else
            %                 % do nothing
            %             end
            
            % exists local min or local max in between?
            if (lastmin<lasty) && (lastmin<y(ind))
                ind= ind1a;
            elseif (lasty<lastmax) && (y(ind)<lastmax)
                ind= ind1b;
            end
        end
        
        indSav(end+1)= ind;
        lastt= t(ind);
        lasty= y(ind);
        lastmin= lasty; ind1a= ind;
        lastmax= lasty; ind1b= ind;
    end
    ind= ind+1;
end
indSav(end+1)= N;

% return the subsampled signals
t2= t(indSav);
y2= y(indSav);

return; % end of main function


% -----------------------------------------------------------------------
function [t2,y2,indSav]= my_sparse_plot_ndim(t, y, options)
% t : Nx1
% y : Nxm

if size(t,2)~=1, error('t must be Nx1'); end
if size(y,1)~=size(t,1), error('y and t lengths must be equal'); end

ind= 1;
indSav= ind;
N= length(t);
N2= 1000;
if isfield(options, 'nPtsForThreshold'), N2= options.nPtsForThreshold; end

% calc thresholds
% max 400 pts horiz and vertically
thres_t= (max(t)-min(t))/N2;
thres_y= (max(y,[],1)-min(y,[],1))/N2;
if max(thres_y)<eps
    thres_y= thres_y+inf; % ignore thres_y
end

% calc subsampling
lastt= t(indSav(end));   % indSav(end)==1
lasty= y(indSav(end),:); % indSav(end)==1
ind= 2;
while ind<N
    if abs(t(ind)-lastt) >= thres_t || any(abs(y(ind,:)-lasty) >= thres_y)
        lastt= t(ind);
        lasty= y(ind,:);
        indSav(end+1)= ind;
    end
    ind= ind+1;
end
indSav(end+1)= N;

% return the subsampled signals
t2= t(indSav);
y2= y(indSav,:);

return; % end of main function


function [t2,y2,indSav]= my_sparse_plot_ndim_struct(x1, namesLst, options)
%[t, y]= my_sparse_plot(x1, {tName, yName, uName});

% find dirs of t vars
for i=1:length(namesLstInd)
    sz= eval(['size(x1.' namesLst{i} ');']);
    if sz(1)<sz(2)
        str= ['x1.' namesLst{i} '(:,i);']
    else
        str= ['x1.' namesLst{i} '(i,:);']
    end
    namesLstSz{i}= sz;
    namesLstGetValues{i}= str;
end

% parse all vars

return; % end of main function


% -----------------------------------------------------------------------
