function pdinner_tst(tstId)
if nargin<1
    tstId= 2; %1;
end
warning('off','MATLAB:dispatcher:InexactCaseMatch');
file_put_in_path('RDP.M');

switch tstId
    case 1, % load the .RDP file

        [Pre, Post, M0] = RDP('PDINNER.RDP')

    case 2, % test the Petri net

        [Pre, Post, M0] = RDP('PDINNER.RDP');
        %[t, M, yout]= PN_sim(Pre, Post, M0, [0 10]);
        [t, M, yout]= PN_sim(Pre, Post, M0, [0 10 .1]);
        plot_all(t, M, yout)

    case 3, % test one conflict

        global flags_want_to_eat table_last_updt_t
        flags_want_to_eat= [0 0 0 0 0 0; 1 1 1 0 0 0];
        table_last_updt_t= now;
        [Pre, Post, M0] = RDP('PDINNER.RDP');
        [t, M, yout]= PN_sim(Pre, Post, M0, [0 10 .1]);
        plot_all(t, M, yout)

    otherwise
        error('invalid tstId')
end

return


function plot_all(t, M, yout)
figure(201), clf;
subplot(3,3,1:6); imshow('pdinner.png'); title('Five philosophers dinner')
opt= struct('plot2',[]);
subplot(3,2,5); plot_z(t, M', opt);    xlabel('time'); ylabel('place number'); grid on;
title('State of the PN along time')
subplot(3,2,6); pdinner_IO; grid on; % show input data
subplot(3,2,6); plot_z(t, yout', opt); xlabel('time'); ylabel('want/got dinner'); grid on;
title('Asked (cyan) vs got (blue) dinner')
