function plot_z(t, z, options)
% Show various time signals, collected as lines z(i,:)
%
% t : 1xN : time range
% z : mxN : signals to show
%
% cstr: string : (facultative) plot modifier

% Nov2013 JG

if nargin<3
    options= [];
end
if ischar(options)
    cstr= options;
elseif isfield(options, 'cstr')
    cstr= options.cstr;
else
    cstr= '.-';
end

if isempty(t)
    x= 1:size(z,2);
else
    x= t(:)';
end
if isfield(options, 'plot2')
    dy= 0.5*z/max(max(abs(z)));
end

washold= ishold;
hold on
for i=1:size(z,1)
    y= i+x*0;
    if ~isfield(options, 'plot2')
        plot3(x, y, z(i,:), cstr)
    else
        plot(x, y+dy(i,:), cstr);
    end
end
if ~washold
    hold off
end
