function rede_resistiva_mostrar_tensoes

% 2.3.08 JGaspar

% filename with the output of PSPICE
fname= 'rede_resistiva-schematic1-simulacao_dc.out';

% get node names
db= parse_file(fname);

% find the matrix of nodes
nodes= find_matrix(db);

% get the voltages at the nodes
V= parse_file_for_voltages(fname, nodes);
V= [V; V(1,:)*0];

% display the voltage matrix
figure(201); clf
[x,y]=meshgrid(1:size(V,2),1:size(V,1)); h=plot3(x(:),y(:),V(:),'.');
set(h, 'markersize', 10, 'color', 'k')
hold on
surf(V); shading interp
axis ij
xlabel('columns');
ylabel('lines R1-R4, ..., R17-R20');
grid on


% --------------------

function db= parse_file(fname)

% db with the names of the resistors
%
for i=1:20
   db{i,1}= sprintf('R_R%d ', i);
   for j=2:3
      db{i,j}= [];
   end
end

% parse file to get the node names
%
fi= fopen(fname, 'rt');
while 1
   tline = fgetl(fi);
   if ~ischar(tline), break, end
   db= parse_line(db, tline);
end
fclose(fi);


function db= parse_line(db0, tline)
% if the tline has something we are looking for, get it
db= db0;
for i=1:size(db,1)
   if isempty(db{i,2}) && strncmp(db{i,1}, tline, length(db{i,1}))
      [db{i,2}, db{i,3}]= get_nodes(tline);
   end
end

function [a,b]= get_nodes(str)
s2= str;
while ~isempty(strfind(s2, '  '))
   s2= strrep(s2, '  ',' ');
end
ind= find(s2==' ');
a= s2(ind(1)+1:ind(2)-1);
b= s2(ind(2)+1:ind(3)-1);


% --------------------

function nodes= find_matrix(db)
% there is a path between every group of 4 resistors
%   nodes r1-r2 r2-r3 r3-r4
%   nodes r5-r6 r6-r7 r7-r8
%   ...
% 20= 5lines*4columns of resist (5*5 nodes of interest)
%

% place in col2 the connected node, and in col3 the non-connected one
%
db2= db;
N= size(db2,1);
for i=1:N-1
   [db2{i,2}, db2{i,3}]= find_match(db{i,2},db{i,3}, db{i+1,2},db{i+1,3});
end
db2{end,2}=''; db2{end,3}= '';
for i=2:N
   if isempty(db2{i,2}) & isempty(db2{i,3})
      [tmp, db2{i,3}]= find_match(db{i,2},db{i,3}, db{i-1,2},db{i-1,3});
   end
end
for i=2:N
   if strcmp(db2{i,3},db2{i-1,2})
      db2{i,3}= '';
   end
end
%db2

% colect nodes in a matrix
%
nodes= cell(5,5); n=1;
for i=1:N
   if ~isempty(db2{i,3})
      nodes{n}= db2{i,3}; n=n+1;
   end
   if ~isempty(db2{i,2})
      nodes{n}= db2{i,2}; n=n+1;
   end
end
nodes= nodes';
%nodes


function [ret, r2]= find_match(a,b,c,d)
% ret==matching node name
% r2= NON matching node name
ret= '';
r2= '';
if strcmp(a,c), ret= a; r2=b; end
if strcmp(a,d), ret= a; r2=b; end
if strcmp(b,c), ret= b; r2=a; end
if strcmp(b,d), ret= b; r2=a; end


% --------------------

function V= parse_file_for_voltages(fname, nodes0)
%
% for each line of the file,
%  try to find if it contains any of the node names in brackets
%

nodes= nodes0;
for i=1:prod(size(nodes))
   nodes{i}= ['(' nodes{i} ')'];
end
V= zeros(size(nodes));

fi= fopen(fname, 'rt');
while 1
   tline = fgetl(fi);
   if ~ischar(tline), break, end
   
   for i=1:size(nodes,1)
      for j=1:size(nodes,2)
         v= parse_line_for_voltage(nodes{i,j}, tline);
         if ~isempty(v), V(i,j)= v; end
      end
   end
end
fclose(fi);


function v= parse_line_for_voltage(name, tline)

v= [];
ind= strfind(tline, name);
if ~isempty(ind)
   v= sscanf(tline(ind(1)+length(name):end), '%f');
end
