function rc_choose_vs(op, arg, options)
%
% Define source signals to be used as inputs by PSPICE
%
% Important limitation: PSPICE aborts simulation if the text line
% specifying the stimulus signal is too large (> 132 caracters)
%

% 3.Nov.2008, Jose Gaspar

if nargin<1
   %rc_choose_vs('t2set', 5.4055); return
   op='2';
end
if isnumeric(op)
   op= num2str(op);
end
if nargin<2
   arg= [];
end
if nargin<3
   options= [];
   %options= struct('sh_signals',[]); % would be too simple, not educative ;-)
end

switch op
   case '0'
      %timeAndValue= mk_steps(0:8, [1:5 0:5]);
      %timeAndValue= mk_steps(0:8, [0 1:5 0:5]);
      timeAndValue= mk_steps(0:2:10, [0 1:5 0:5]);
      %timeAndValue= '0ms, 0V, 0.001ms, 6V, 1ms, 6V, 1.001ms, 0V, 2ms, 0v';

   case '1'
      timeAndValue= '0s,0V,0.001s,1V,5s,1V, 5.001s,3V,10s,3V'; % low high pulses
   case '2'
      timeAndValue= '0s,0V,0.001s,5V,5s,5V, 5.001s,3V,10s,3V'; % high low pulses
   case '3'
      timeAndValue= '0s,0V,0.001s,3V,5s,3V, 5.001s,3V,10s,3V'; % constant value
      
   case 't2set'
      timeAndValue= set_zero_pulse(arg);
   case 'fast_pulse'
      timeAndValue= '0s,0V,0.001s,10V,1s,10V, 1.001s,3V,10s,3V'; % high low pulses
      
   case '2step'
      timeAndValue= input_2step(arg);
   case '3step'
      timeAndValue= input_3step(arg);

   otherwise
      error(['invalid option: ', op])
end

% this is the normal way to use rc_choose_vs
%
if isfield(options, 'sh_signal')
   plot_stimulus(timeAndValue)
elseif isfield(options, 'sh_signals')
   plot_stimulus(timeAndValue)
   sh_guess(timeAndValue)
else
   write_stimulus_file(timeAndValue)
end

% the following code is just for windows and assumes PSPICE in the default
% path location
%
% THIS IS NOT WORKING: DO NOT USE
%
% if isfield(options, 'run_pspice')
%    write_stimulus_file(timeAndValue)
%    !"C:\Program Files\OrCAD_Demo\PSpice\pspice.exe" rc_resp-schematic1-simulacao_dc.sim.cir
%    disp('Press RET after runing and closing PSPICE...')
%    pause
%    rc_resp_show
% end
   
return; % end of main function


% ---------------------------------------------------
function str= mk_steps(t,v)
str='';
for i=1:length(t)-1
   %str= [str sprintf(' %.3fms %.3fV %.3fms %.3fV', t(i), v(i), t(i+1)-0.001, v(i))];
   str= [str sprintf(' %.0f %.0f %.2f %.0f', t(i), v(i), t(i+1)-0.01, v(i))];
end


function timeAndValue= set_zero_pulse(t2)
%
% return a constant signal of 3v, 0..10s, with
%    a zero pulse from 5s till t2
%
t2a= sprintf('%f', t2);
t2b= sprintf('%f', t2+0.001);
str1= '0s,0V,0.001s,3V,5s,3V,';
str2= ['5.001s,0V,' t2a ',0V,'];
str3= [t2b ',3V,10s,3V'];
timeAndValue= [str1 str2 str3];


function timeAndValue= input_2step(arg)
if isempty(arg)
   fprintf(1, '-- input values to define two pulses (0..t1 and t1..10s)\n');
   t1= myinput('t1 [sec] = ');
   v1= myinput('Vs(0..t1) [V] = ');
   v2= myinput('Vs(t1..10s) [V] = ');
else
   t1=arg(1); v1=arg(2); v2=arg(3);
end
timeAndValue= sprintf('0 0 %s %g %g %g %g %g %g %g', ...
   '1e-3',v1,t1,v1, t1+1e-3,v2,10,v2);


function timeAndValue= input_3step(arg)
if isempty(arg)
   fprintf(1, '-- input values to define three pulses (0..t1, t1..t2 and t2..10s)\n');
   t1= myinput('t1 [sec] = ');
   t2= myinput('t2 [sec] = ');
   v1= myinput('Vs(0..t1) [V] = ');
   v2= myinput('Vs(t1..t2) [V] = ');
   v3= myinput('Vs(t2..10s) [V] = ');
else
   t1=arg(1); t2=arg(2);
   v1=arg(3); v2=arg(4); v3=arg(5);
end
timeAndValue= sprintf('0 0 %s %g %g %g %g %g %g %g %g %g %g %g', ...
   '1e-3',v1,t1,v1, t1+1e-3,v2,t2,v2, t2+1e-3,v3,10,v3);


function x= myinput(str)
x= [];
while isempty(x)
   x= str2num(input(str, 's'));
end
%x= x(1); % NO multiple inputs


% ---------------------------------------------------
function sh_guess(timeAndValue, tau, maxt)
if nargin<2
   tau=1; % sec
end
if nargin<3
   maxt=10; % sec
end
tx= convert_str_to_values(timeAndValue);
%
% ... still to complete (without using the control toolbox ...)
% interpolate the source values and then solve Vc(t) ...
%
% much simpler: assume the input contains only step functions
%
i=1;
ttvv=[];
while i<size(tx,2)
   if tx(2,i)==tx(2,i+1)
      x= tx(:,[i i+1]);
      ttvv= [ttvv; tx(1,i) tau 0 tx(2,i); tx(1,i+1) tau 0 tx(2,i+1)];
      i= i+2;
   else
      i= i+1;
   end
end
rc_resp_guess('1step', ttvv, struct('link_vc',[]));


function plot_stimulus(timeAndValue)
tx= convert_str_to_values(timeAndValue);
h= plot(tx(1,:), tx(2,:), '.-');
set(h, 'lineWidth', 3);


function tx= convert_str_to_values(timeAndValue)
str= timeAndValue;
str= strrep(str, ',', ' ');
str= strrep(str, 'V', ' ');
str= strrep(str, 'v', ' ');
str= strrep(str, 'S', ' ');
str= strrep(str, 's', ' ');
str= strrep(str, 'm', 'e-3');
str= strrep(str, 'k', 'e+3');
tx= str2num(str);
tx= reshape(tx, 2, []);


% ---------------------------------------------------
function write_stimulus_file(timeAndValue)
fo= fopen('RC_RESP.stl', 'wt');
if fo<0
   error('opening "RC_RESP.stl"')
end

fprintf(fo, '* \n');
fprintf(fo, '* by Stimulus Editor -- Evaluation Version 9.1\n');
fprintf(fo, ';!Stimulus Get\n');
fprintf(fo, ';! my_vstim Analog\n');
fprintf(fo, ';!Ok\n');
fprintf(fo, ';!Plot Axis_Settings\n');
fprintf(fo, ';!Xrange 0s 3ms\n');
fprintf(fo, ';!Yrange -2 4\n');
fprintf(fo, ';!AutoUniverse\n');
fprintf(fo, ';!XminRes 1ns\n');
fprintf(fo, ';!YminRes 1n\n');
fprintf(fo, ';!Ok\n');
%.STIMULUS my_vstim PWL(0ms, 0V, 0.001ms, 6V, 1ms, 6V, 1.001ms, 0V, 2ms, 0v)

str= sprintf('.STIMULUS my_vstim PWL(%s)\n', timeAndValue);
if length(str)>=132
   %
   % This is a ugly limitation of PSPICE / stimulus:
   %   it aborts the simulation if the text line is larger than 132
   % TODO: find a way of importing a stimulus signal directly from a file
   %
   warning('line too long for PSPICE simulation')
end
fprintf(fo, str);

fclose(fo);

fprintf(1, 'Writen a new stimulus file.\n')
