function pdinner_tst(tstId)
% Simulate the "five philosophers dinner problem".

% Nov2013, April2021 (RDP.m not mandatory), J. Gaspar

if nargin<1
    tstId= 3; %2; %1;
end
warning('off','MATLAB:dispatcher:InexactCaseMatch');

switch tstId
    case 0
        % load the .RDP file, usage: pdinner_tst(0)
        file_put_in_path('rdp.m');
        [Pre, Post, M0] = rdp('PDINNER.RDP')
        
    case 1
        % show input data, usage: pdinner_tst(1)
        figure(201), clf; pdinner_IO; grid on;
        
    case {2, 3}
        % test the Petri net,  pdinner_tst(2)  or  pdinner_tst(3)
        
        % 1. load PN gives matrices Pre, Post and vector M0
        if tstId==2
            file_put_in_path('rdp.m');
            [Pre, Post, M0] = rdp('PDINNER.RDP');
        else
            [Pre, Post, M0] = mk_PN;
        end

        % 2. run the simulation, see results in a structure:
        %    ret.t, ret.qin, ret.M, ret.yout
        %ret= PN_sim(Pre, Post, M0, [0 10 .1]);
        ret= PN_sim(Pre, Post, M0, [0 10 .01]); % improved resolution plots
        
        % plot the results
        figure(201), clf;
        subplot(3,3,1:6); imshow('pdinner.png'); title('Five philosophers dinner')
        subplot(3,2,5); plot_z(ret.t, ret.M, '-');    xlabel('time'); ylabel('place number'); grid on;
        title('State of the PN along time')
        subplot(3,2,6); plot_z(ret.t, ret.qin(:,1:5), 'co-'); grid on; % show input data
        subplot(3,2,6); plot_z(ret.t, ret.yout, '.-'); xlabel('time'); ylabel('want/got dinner'); grid on;
        title('Dinner asked (cyan) vs got (other colors)')
        
        % eval satisfied requests
        N= size(ret.yout,2);
        satisf_perc= (1-sum(ret.qin(:,1:N)-ret.yout)/length(ret.yout))*100
        
    otherwise
        error('invalid tstId')
end

return


function [Pre, Post, M0]= mk_PN
% Define by hand the PN, for standalone usage i.e. not requiring RDP.m

% Incidence Matrix, D  =>  (D+,D-) or (Post,Pre) :
D= [
    -1  0  0  0  0  1  0  0  0  0
     1  0  0  0  0 -1  0  0  0  0
     0 -1  0  0  0  0  1  0  0  0
     0  1  0  0  0  0 -1  0  0  0
     0  0 -1  0  0  0  0  1  0  0
     0  0  1  0  0  0  0 -1  0  0
     0  0  0 -1  0  0  0  0  1  0
     0  0  0  1  0  0  0  0 -1  0
     0  0  0  0 -1  0  0  0  0  1
     0  0  0  0  1  0  0  0  0 -1
    -1  0  0  0 -1  1  0  0  0  1
    -1 -1  0  0  0  1  1  0  0  0
     0 -1 -1  0  0  0  1  1  0  0
     0  0 -1 -1  0  0  0  1  1  0
     0  0  0 -1 -1  0  0  0  1  1
    ];
Pre = -D.*(D<0);
Post=  D.*(D>0);

% Inicial Marking :
M0= [1 0 1 0 1 0 1 0 1 0 1 1 1 1 1]';
