#ifndef __CDK13_YY_PARSER_H__
#define __CDK13_YY_PARSER_H__

#include <cdk/basic_parser.h>
#include <cdk/yy_scanner.h>

/**
 * This is the external parsing function.
 * It is automatically generated by 'byacc'
 */
extern int yyparse(std::shared_ptr<cdk::compiler> compiler);

namespace cdk {

  /**
   * This class corresponds to the parser as implemented by a tool
   * such as byacc.
   */
  template<typename LexerType>
  class yy_parser: public basic_parser {

  public:
    /** @param language is the name of the parsed language. */
    yy_parser(const std::string &language) :
        basic_parser(language, std::make_shared<yy_scanner<LexerType>>(language)) {
    }

    int parse() {
      return ::yyparse(_compiler);
    }

  };

} // cdk

#endif
