#!/usr/bin/perl

$pvdecls = $incls = '';
$namespace = $ARGV[0];

open NODES, "find ast -name \\*.h -exec grep -H 'accept' {} \\; | grep -v basic_node | cut -d: -f1 | sed -e 's=^.*/==g' | "
  or die "Could not list node headers";
while (<NODES>) {
  if (m/\ball\.h\b/) { next; }
  chomp;
  $pvdecl = $incl = $_;

  # Handle declaration
  #
  $pvdecl =~ s-(([[:alnum:]]|_)+?)\.h-  virtual void do_$1($namespace::$1 *const node, int lvl) = 0;-;
  $pvdecls .= "$pvdecl\n";

  # Handle include
  #
  $incl =~ s-(([[:alnum:]]|_)+?)\.h-  void do_$1($namespace::$1 *const node, int lvl);-;
  $incls .= "$incl\n";
}
close NODES;

# HACKS!

$cdkvisitorinclude = '';
if ($namespace ne "cdk") {
  $cdkvisitorinclude = "#include <cdk/ast/visitor_decls.h>\n";
}

#
# File "nodes/all_visitor_decls.h" will now be produced.
#
print<<__EOF__;
// **** AUTOMATICALLY GENERATED BY mk-visitor-decls.pl -- DO NOT EDIT ****
$cdkvisitorinclude
#ifdef __IN_VISITOR_HEADER__

#ifdef __PURE_VIRTUAL_DECLARATIONS_ONLY__

$pvdecls

#else

$incls

#endif /* !defined(__PURE_VIRTUAL_DECLARATIONS_ONLY__) */

#endif /* __IN_VISITOR_HEADER__ */
__EOF__

###########################################################################

0;

###########################################################################
