package main

import (
	"fmt"
	"log"
	"math"
	"os"
	"strconv"
)

// Producer(ch) sends the stream of all natural numbers
// starting from 2 on ch.
func Producer(ch chan<- int) {
	for i := 2; ; i++ {
		ch <- i
	}
}

// Sieve(in,out,prime) transduces a stream of naturals, received on
// channel in, to a stream of naturals, emitted on channel out,
// filtering out all numbers divisible by prime.
func Sieve(in <-chan int, out chan<- int, prime int) {
	for {
		n := <-in
		if n%prime != 0 {
			out <- n
		}
	}
}

func main() {
	ch := make(chan int)
	go Producer(ch)
	var count int
	var err error
	if len(os.Args) > 1 {
		count, err = strconv.Atoi(os.Args[1])
		if err != nil {
			log.Println("[Primes] Warning: Bad limit, assuming max. int32 --", err)
			count = math.MaxInt32
		}
	} else {
		count = math.MaxInt32
	}
	for i := 0; i < count; i++ {
		prime := <-ch
		fmt.Printf("%d ", prime)
		ch1 := make(chan int)
		go Sieve(ch, ch1, prime)
		ch = ch1
	}
	fmt.Println()
}
