package main

import (
	"bufio"
	"fmt"
	"log"
	"net"
	"os"
	"strings"
	"sync"
)

func client(name string, addr string) {
	conn, err := net.Dial("tcp", addr)
	if err != nil {
		log.Fatal(err)
	}
	defer conn.Close()
	reader := bufio.NewReader(conn)
	for {
		time, err := reader.ReadString('\n')
		if err != nil {
			log.Fatal(err)
		}
		fmt.Print(name + " " + time)
	}
}

func main() {
	var wg sync.WaitGroup

	args := os.Args[1:]
	for _, s := range args {
		splitStr := strings.Split(s, "=")
		clockName := splitStr[0]
		wg.Add(1)
		go client(clockName, splitStr[1])

	}
	wg.Wait()
}
