function outpImg= remap2d(inpImg, lut,lutParams)
%
% function outpImg= remap2d(inpImg, lut,lutParams)
%
% Remap input image inpImg to outpImg using 2D lookup table lut
%
% inpImg - input image
% lut - 2D lookup table (trully a vector w/ indexes) for pixel remapping
% lutParams - parameters required to understand lut
%   lutParams= [outpImgNLins, outpImgNCols, ...
%               inpImgNLins,  inpImgNCols, minX,maxX, minY,maxY]
%   0<=minX<=maxX<inpImgNCols, 0<=minY<=maxY<inpImgNLins
%
% See Also: remap2di (read lut2d), remap2dc (change lut2d),
%           remap2ds (save/write lut2d)

% 1/10/98, J. Gaspar
%

% check lutParams
%
outpImgNLins= lutParams(1); outpImgNCols= lutParams(2);
inpImgNLins= lutParams(3);  inpImgNCols= lutParams(4);
minX= lutParams(5); maxX= lutParams(6);
minY= lutParams(7); maxY= lutParams(8);

if inpImgNLins ~= size(inpImg,1),
  error('lut prepared for images with a different number of lines');
end

if minX<0 | minY<0 | maxX>size(inpImg,2)-1 | maxY>size(inpImg,1)-1,
  error('lutParams or inpImg problem: minX<1 | minY<1 | maxX>size(inpImg,2) | maxY>size(inpImg,1)');
end

if outpImgNLins*outpImgNCols ~= length(lut),
  error('lutParams or lut problem: outpImgNLins*outpImgNCols ~= length(lut)');
end

% finaly make the remap
%
outpImg= reshape(inpImg(lut), outpImgNLins, outpImgNCols);
