function img= pi5read(filename)
%
% PI5READ Read a modified PGM-P5 (Portable Gray Map image) file from disk.
%         X=PI5READ('filename') reads the file 'filename' and returns
%         the image X.
%         PI5 is stores unsigned integers (2 bytes / pixel) instead
%         of unsigned chars.
%
%         See also: PI5WRITE

% 9/9/98, 1/10/98(PI5), J.Gaspar

fid= fopen(filename,'r');
if fid<0,
  error(['Opening input file: ' filename]);
end

p5= fread(fid,3,'uchar');
if abs(max(upper(p5') - ['PI5']))>0,
  error(['not PI5 the first three characters of image file:' filename]);
end

nCols= p5readti(fid);
nLins= p5readti(fid);
maxV=  p5readti(fid);  % this value is ignored

img= fread(fid, [nCols nLins], 'ushort')';

fclose(fid);
