function p5write(img, filename)
%
% P5WRITE Write a PGM-P5 (Portable Gray Map image) file to disk.
%   P5WRITE(X,'filename') writes a PGM-P5 file containing the
%   image X to a disk file called 'filename'.
%
%        See also: P5READ

% 9/9/98, J.Gaspar

fid= fopen(filename,'w');
if fid<0,
  error(['Opening output file: ' filename]);
end

header= ['P5' 10 num2str(size(img,2)) ' ' num2str(size(img,1))];
header= [header 10 '255' 10];

fwrite(fid, header, 'uchar');

fwrite(fid, img', 'uchar');

fclose(fid);
