function demo
%
% Demo of vertical and ground dewarping (remapping) of omnidirectional images
%
% 1/7/02, J. Gaspar

% load LookUp Tables (LUTs)
%
disp('-- loading LUTs...')
[lut1, lut1params]= remap2di('panview2.x', 'panview2.y', 576,768);
[lut2, lut2params]= remap2di('guw.x',      'guw.y',      576,768);

% Apply the LUTs to the images
%
fname= {'door041.jpg', 'door116.jpg', 'door266.jpg'};
for n=1:length(fname),
   %
   disp('-- loading image...')
   img= imread(fname{n});
   %
   disp('-- applying remapping...')
   img_vuw= remap2d(img, lut1, lut1params);
   img_guw= remap2d(img, lut2, lut2params);
   %
   % display images
   %
   figure(201)
   subplot(221); imshow(img);     xlabel('Original OD image')
   subplot(222); imshow(img_guw); xlabel('Bird''s eye view')
   subplot(212); imshow(img_vuw); xlabel('Panoramic view')
   
   disp('** press return to continue...')
   pause
end
