function [tAll,VcAll]= rc_resp_guess(op, arg, options)
%
% Ask the user to give the details (constants) of the
% chained RC-responses and plot the complete chained-response
%

% 3.Nov.2008, Jose Gaspar

if nargin<1
   op='2step';
end
if nargin<2
   % in each row of arg is ttvv: tIni tau vIni vInf
   arg= [0 1 0 1; 5 1 1 3]; % ok
   arg= [0 1 0 1; 1 1 1 3]; % wrong arg(2,1)==1 => NON steady state
   arg= [0 1 0 1; 1 1 0 3; 3 1 0 1]; % highly wrong, just to test...
   arg= [];
end
if nargin<3
   options=[];
   %options= struct('link_vc',[]); % makes things too easy, non educative ;-)
end

switch op
   case '1step'
      ttvv= input_ttvv(arg, 1);
   case '2step'
      ttvv= input_ttvv(arg, 2);
   case '3step'
      ttvv= input_ttvv(arg, 3);
   otherwise
      error(['invalid option: ', op])
end

maxt= 10; % sec
if isfield(options, 'maxt')
   maxt= options.maxt;
end
if isfield(options, 'just_retv')
   [tAll,VcAll]= simul_ttvv(ttvv, maxt, options);
else
   plot_ttvv(ttvv, maxt, options);
end

return; % end of the main function


% ---------------------------------------
function plot_ttvv(ttvv, maxt, options)
[tAll,VcAll]= simul_ttvv(ttvv, maxt, options);
hold on
for i=1:length(tAll)
   plot(tAll{i}, VcAll{i}, 'r.-')
end
hold off
grid on
ylabel('Voltage [Volts]')
xlabel('time [seconds]')


% ---------------------------------------
function [tAll,VcAll]= simul_ttvv(ttvv, maxt, options)
tAll={};
VcAll={};
%
VcIniSav= ttvv(1,3); % a global starting point
%
N= size(ttvv,1);
for i=1:N
   if i==N
      t= [ttvv(i,1) maxt];
   else
      t= [ttvv(i,1) ttvv(i+1,1)];
   end
   t= t(1):(t(2)-t(1))/100:t(2);

   tIni= ttvv(i,1);
   tau= ttvv(i,2);
   VcIni= ttvv(i,3);
   VcInf= ttvv(i,4);
   if isfield(options, 'link_vc')
      VcIni= VcIniSav;
   end

   % the main computation of the response is here:
   %
   Vc= VcInf+(VcIni-VcInf)*exp(-(t-tIni)/tau);

   if isfield(options, 'link_vc') && i<N
      tf= ttvv(i+1, 1);
      VcIniSav= VcInf+(VcIni-VcInf)*exp(-(tf-tIni)/tau);;
   end

   tAll{i}= t;
   VcAll{i}= Vc;
end


% ---------------------------------------
function ttvv= input_ttvv(arg, nTimes)
% warning non continuous voltage
% warning time .out older .stl (stimulus)
%
if ~isempty(arg)
   ttvv= arg;
   return
end

ttvv= [];
str= {'first', 'second', 'third', 'forth', 'fifth', 'sixth'};
if nTimes>length(str)
   warning('too many inputs, truncating their number...')
   nTimes= length(str);
end
for i=1:nTimes
   fprintf(1, '-- input %s pulse response:\n', str{i});
   ttvv= [ttvv; input_time_tau_v1_v2];
end


function ttvv= input_time_tau_v1_v2
t0= myinput('start time [sec] = ');
tau= myinput('tau [sec] = ');
vc1= myinput('Vc(t=ini) [Volt] = ');
vc2= myinput('Vc(t=inf) [Volt] = ');
ttvv= [t0,tau,vc1,vc2];


function x= myinput(str)
x= [];
while isempty(x)
   x= str2num(input(str, 's'));
end
%x= x(1); % NO multiple inputs
