function TM_tape_log( op )
%
% 1. Log the use of a Tape inserted in a Turing Machine.
% 2. Show the log of the use of the Tape.

% Oct2016, J. Gaspar

if nargin<1
    op= 'show2';
end

global TMT
switch op
    case 'ini'
        if isfield(TMT, 'fid') && ~isempty(TMT.fid)
            error('output file is already open, please close it first')
        end
        TMT.fid= fopen('TM_tape_log.txt', 'wt');

    case 'write'
        x= get_values( TMT.posMin, TMT.posMax, TMT.val, TMT.valNeg );
        fprintf(TMT.fid, '%3d %3d %3d %3d  ', TMT.stepNumber, TMT.pos, TMT.posMin, length(x));
        fprintf(TMT.fid, ' %d', x);
        fprintf(TMT.fid, '\n');

    case 'end'
        fclose(TMT.fid);
        TMT.fid= [];

    case 'show'
        fprintf(1, 'StepNumber, pos, posMin, tapeLength, tapeWritten:\n')
        type('TM_tape_log.txt')

    case 'show2'
        show2
        
    otherwise, error('inv op');
end


function x= get_values( posMin, posMax, val, valNeg )
x= [valNeg(-posMin:-1:1) val(1:posMax+1)];


function show2
% Display TM tape evolution as an image

fname= 'TM_tape_log.txt';
fid= fopen(fname, 'rt');
x1buff= []; x2buff= {};
while 1
    % get line
    [okFlag, x1, x2]= show2_get_line_of_values( fid );
    if ~okFlag
        break
    end
    % fprintf(1, '%d ', [x1 x2]); fprintf(1, '\n'); % debug
    x1buff(end+1,:)= x1;
    x2buff{end+1, 1}= x2;
end
fclose(fid);

img= mk_matrix(x1buff(:,3), x2buff);
%img= fliplr(img);
if size(img,1)<=110
    k= 4; if size(img,1)<20, k= 20; end
    img= imresize(img, k, 'nearest');
end
figure(201); clf; imshow(img)
%x= get(gca, 'Position'); x(2)=.05; x(4)=.9; set(gca, 'Position', x)
ylabel('time'); xlabel('tape position')

return


function [okFlag, x1, x2]= show2_get_line_of_values( fid )
okFlag= 1;

% get 4 values
[x1, cnt]= fscanf( fid, '%d', 4); x1= x1(:)';
if cnt<4
    okFlag= 0;
    x2= []; % likely end of file
    return
end

% get the 1D array comming next
x2= fscanf( fid, '%d', x1(4) ); x2= x2(:)';


function img= mk_matrix(x1buff, x2buff)
img= ones( length(x1buff), length(x2buff{end,1}) );
x1delta= 1-x1buff(end); % x1buff(end)+x1delta == 1
for i=1:length(x1buff)
    x= x2buff{i,1};
    j= x1buff(i)+x1delta;
    j= j:j+length(x)-1;
    img(i,j)= (x==0); % save zeros as ones (and ones as zeros)
end
