function ret= TM_tape( op, arg1 )
%
% Implement a tape for a Turing machine, encompassing the basic operations:
%   read/write and move Left/Right/None

% Nov2015, Oct2016, J. Gaspar

if nargin<1, demo; return; end

global TMT % Turing Machine Tape
if isempty(TMT)
    TM_reset
end

switch op
    case 'reset', TM_reset;

    case 'read'
        realloc_if_needed( TMT.pos ); % 1st call may need tape
        if TMT.pos>=0
            ret= TMT.val( TMT.pos+1 );
        else
            ret= TMT.valNeg( -TMT.pos );
        end
        
    case 'write'
        realloc_if_needed( TMT.pos ); % 1st call may need tape
        if TMT.pos>=0
            TMT.val( TMT.pos+1 )= arg1;
        else
            TMT.valNeg( -TMT.pos )= arg1;
        end
        if TMT.pos < TMT.posMin
            TMT.posMin= TMT.pos;
        end
        if TMT.pos > TMT.posMax
            TMT.posMax= TMT.pos;
        end
        TMT.stepNumber= TMT.stepNumber+1;

    case 'move'
        switch arg1
            case 'L', TMT.pos= TMT.pos+1;
            case 'R', TMT.pos= TMT.pos-1;
            case 'N' % do nothing
            otherwise
                error('inv tape move op');
        end
        
    case 'left',  TM_tape( 'move', 'L' )
    case 'right', TM_tape( 'move', 'R' )
    case {'none', 'null_move'}, TM_tape( 'move', 'N' )

    otherwise
        error('inv op')
end

return; % end of main function


function TM_reset
global TMT % Turing Machine Tape
TMT= struct('pos',0, 'posMin',0, 'posMax',0, 'val',[], 'valNeg',[], 'stepNumber',0);


function y= realloc_if_needed_aux( x, pos )
y= x;
if pos>length(x)
    for i=(pos+100):-1:length(x)+1
        y(i)=0;
    end
end


function realloc_if_needed( arg1 )
global TMT % Turing Machine Tape
if arg1>=0
    pos= arg1+1;
    TMT.val= realloc_if_needed_aux( TMT.val, pos );
else
    pos= -arg1;
    TMT.valNeg= realloc_if_needed_aux( TMT.valNeg, pos );
end


function demo
TM_tape('reset');

% do 10x left move
for i=1:10
    TM_tape('move', 'L');
end

% write 15 values while moving the tape to the right
for i=10:-1:-5
    TM_tape('write', i);
    TM_tape('move', 'R');
end

% display the values written
for i=-5:10
    TM_tape('move', 'L');
    fprintf(1, 'tape read= %d\n', TM_tape('read'));
end
