function TM_run( machineId, options )
%
% Run a Turing Machine based in a Finite State Machine (FSM)
%
% Usage:
% >> TM_run
% >> TM_run( 'BusyBeaver3' )

% Oct2016, J. Gaspar

if nargin<2
    options= [];
end
if nargin<1
    demo
    return
end

[FSM, curr_state]= TM_ini( machineId, options );
TM_tape( 'reset' );
TM_tape_log('ini');

while ~strcmpi(curr_state, 'halt')
    
    for i=1:size(FSM,1)

        if strcmpi(FSM{i,1}, curr_state) && eval( FSM{i,2} )
            % found state and true condition
            eval( FSM{i,3} );
            curr_state= FSM{i,4}; % curr_state gets the next state
            TM_tape_log('write');
            break;
        end
        
        if i==size(FSM,1) && ~strcmpi(FSM{i,1}, curr_state)
            fprintf(1, 'Current state: %s\n', curr_state);
            error('Machine is in an invalid state')
        end
    end
    
end

TM_tape_log('end');
TM_tape_log('show');
TM_tape_log('show2');

return; % end of function


function demo
% TM_run( 'BusyBeaver3' ); pause
% TM_run( 'BusyBeaver4' );
% %TM_run( 'BusyBeaver5' ); % <- do NOT run this, it takes too long

ButtonName = questdlg('Turing Machine demo?', ...
    'TM demo select', ...
    'BusyBeaver3', 'BusyBeaver4', 'Cancel', 'BusyBeaver3');
switch ButtonName,
    case 'BusyBeaver3', TM_run( 'BusyBeaver3' )
    case 'BusyBeaver4', TM_run( 'BusyBeaver4' )
    case 'Cancel',
end
