#!/bin/bash
export NAME_DETECTOR=/wavingDetector
export NAME_CONFIGFILE=./wavingDetector.ini
export NAME_SOURCE_IMAGE=/grabber
export GROUP_NAME=CAMERA
export VIEWER=/wavingDetector/viewer

killall xterm
#start camera devices
xterm -T "video grabber" -e 'yarpdev --device opencv_grabber --name $NAME_SOURCE_IMAGE --framerate 10 --movie "/home/plinio/work/urus/wavingDetector/cam-192.168.11.5-20081127-1455  2274_2980.avi" --loop' &
yarp wait $NAME_SOURCE_IMAGE

#start waving detector for camera $1
xterm -T "waving detector" -e "./wavingDetect --name $NAME_DETECTOR --file $NAME_CONFIGFILE --group CAMERA1" &
yarp wait $NAME_DETECTOR/rgb

# Connect source image
yarp connect $NAME_SOURCE_IMAGE $NAME_DETECTOR/rgb

xterm -T "viewer" -e "yarpview $VIEWER" &
yarp wait $VIEWER

yarp connect $NAME_DETECTOR/out $VIEWER

# Connect output ports to Camera Proxy
#yarp connect $NAME_DETECTOR1/data-feed/output/guardingDoor /CentralStation/CameraNetworkProxy/camera-inputs/enterRoomInput

#yarp connect $NAME_DETECTOR/data-feed/output/wave /CentralStation/CameraNetworkProxy/camera-inputs/wavePositionInput
