#!/bin/bash
export NAME_DETECTOR=/camera$1/wavedetect
export NAME_CONFIGFILE=wavingDetector.ini
export NAME_SOURCE_IMAGE=/camera$1
export VIEWER=/view$1
export WAVING_DIR=/home/plinio/wavingDetector
export OLD_PATH=$PATH
export PATH=$PATH:$WAVING_DIR

if [ "$1" = "1" ]; then
       MY_CAMERA=1
fi
if [ "$1" = "2" ]; then
       MY_CAMERA=2
fi
if [ "$1" = "3" ]; then
       MY_CAMERA=0
fi
if [ "$1" = "4" ]; then
       MY_CAMERA=0
	echo $MY_CAMERA
fi
if [ "$1" = "5" ]; then
       MY_CAMERA=1
fi


#start yarp server
# yarp namespace /urus
# konsole -T "YARP SERVER" -vt_sz 120x05 -e yarp server &
# sleep 2s
# yarp wait /urus
# 
# #start Camera Proxy
# konsole -T "CAMERA PROXY" cameraNetworkProxy &
# sleep 1s

#start camera devices
konsole -T "GRABBER #$1" -vt_sz 40x05 -e yarpdev --device opencv_grabber --camera $MY_CAMERA --name $NAME_SOURCE_IMAGE  --framerate 30 &
yarp wait $NAME_SOURCE_IMAGE

#start waving detector for camera $1
konsole -T "BackTDcamera$1" -vt_sz 120x05 -e wavingDetect --name $NAME_DETECTOR --file $NAME_CONFIGFILE --group CAMERA$1 &
yarp wait $NAME_DETECTOR/rgb

konsole -T "VIEW #$1" -vt_sz 10x10 -e yarpview $VIEWER &
yarp wait $VIEWER

# Connect source image
yarp connect $NAME_SOURCE_IMAGE $NAME_DETECTOR/rgb

yarp connect $NAME_DETECTOR/out $VIEWER

# Connect output ports to Camera Proxy
#yarp connect $NAME_DETECTOR1/data-feed/output/guardingDoor /CentralStation/CameraNetworkProxy/camera-inputs/enterRoomInput

yarp connect $NAME_DETECTOR/data-feed/output/wave /CentralStation/CameraNetworkProxy/camera-inputs/wavePositionInput

export PATH=$OLD_PATH