@ECHO OFF
ECHO.

REM Copyright (C) 2007 Plinio Moreno
REM CopyPolicy: Released under the terms of the GNU GPL v2.0.

:: Configuration
SET NAME_DETECTOR=/wavingDetector
SET NAME_CONFIGFILE=wavingDetector.ini
::SET NAME_CONFIGFILE=mptFaceDetector.ini
SET NAME_SOURCE_IMAGE=/grabber
SET EXEC_TYPE=release
SET GROUP_NAME=CAMERA1

:: Command line arguments
IF NOT "%1" == "" SET NAME_SOURCE_IMAGE=%1

:: replace \'s with /'s in UZHICUB_DIR (needed for yarp)
SET ICUB_DIR_MOD=%ICUB_DIR:\=/%

:: Start image grabber
::start "opencv_grabber" cmd /c yarpdev --device opencv_grabber --name %NAME_SOURCE_IMAGE% --framerate 30
::start "opencv_grabber" cmd /c yarpdev --device opencv_grabber --width 160 --height 120 --name %NAME_SOURCE_IMAGE% --framerate 30
::start cmd /c yarpdev --device opencv_grabber --name /grabber --framerate 10 --movie "H:/urus/sequences/detectorExample/detectorPlinioSequenceC.avi" --loop
start cmd /c yarpdev --device opencv_grabber --name /grabber --framerate 10 --movie "H:/urus/sequences/PlinioActivities.avi" --loop

:: Start face detector
::start %ICUB_DIR%\bin\release\faceeyedetector.exe --name %NAME_DETECTOR% --file c:/temp/%NAME_CONFIGFILE%
start %EXEC_TYPE%\wavingDetect.exe --name %NAME_DETECTOR% --file %NAME_CONFIGFILE% --group %GROUP_NAME%
:: Start viewers 
start yarpview --RefreshTime 29 --name /view%NAME_DETECTOR% --PosX 20 --PosY 20

:: Connect source image
yarp wait %NAME_DETECTOR%/rgb
yarp connect %NAME_SOURCE_IMAGE% %NAME_DETECTOR%/rgb
:: Connect  to viewer
yarp wait /view%NAME_DETECTOR%
yarp connect %NAME_DETECTOR%/out /view%NAME_DETECTOR%

:: Start viewers 
start yarpview --RefreshTime 29 --name /view%NAME_SOURCE_IMAGE% --PosX 20 --PosY 20

:: Connect source image
yarp wait %NAME_SOURCE_IMAGE%
yarp connect %NAME_SOURCE_IMAGE% /view%NAME_SOURCE_IMAGE%

::optical flow viewer
::yarp wait /test/opticalFlow
::start yarpview --RefreshTime 29 --name /view/opticalFlow --PosX 40 --PosY 40
::yarp connect /test/opticalFlow /view/opticalFlow
GOTO:EOF

:Syntax
ECHO Usage: startChicaSalienceLeft.bat [/image/source/port]
GOTO:EOF