// -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*-

/*
 * Copyright (C) 2007 
 * CopyPolicy: Released under the terms of the GNU GPL v2.0.
 *
 */

#ifndef WAVINGDETECTORMODULE__
#define WAVINGDETECTORMODULE__

 // std
#include <stdio.h>
#include <iostream>
//#include <fstream>
//#include <sstream>
//#include <string>
//#include <vector>

// opencv
#include <cv.h>


// yarp
#include <yarp/os/all.h>
#include <yarp/sig/all.h>
#include <yarp/sig/Matrix.h>

#include <WavingDetector.h>

using namespace std;
using namespace yarp::os;
using namespace yarp::sig;


/**
 *
 * ...
 *
 * \see icub_camcalibconf
 *
 */
class WavingDetectorModule : public Module {

private:
	IplImage *_currentImage;
	WavingDetector targetDetector;

	//In
    BufferedPort<ImageOf<PixelRgb> >    _prtImgRgb;
	
	//Out
	BufferedPort<Matrix> _prtBoundBoxes;
	BufferedPort<ImageOf<PixelRgb> >	_prtImgActRgb;
	int imageCounter;

public:

    WavingDetectorModule();
    ~WavingDetectorModule();
    
    virtual bool open(Searchable& config);
    virtual bool close();
    virtual bool interruptModule();
    virtual bool updateModule();
	void drawDetectedBoxes(IplImage *currentImage, int lineThickness, CvScalar color);
};

#endif

