// -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*-

/*
* Copyright (C) 2007 
* CopyPolicy: Released under the terms of the GNU GPL v2.0.
*
*/

#include <WavingDetectorModule.h>
#include <highgui.h>
WavingDetectorModule::WavingDetectorModule(){

}

WavingDetectorModule::~WavingDetectorModule(){
	// data is released trough close/interrupt methods
}

bool WavingDetectorModule::open(Searchable& config){

	targetDetector.open(config);
	// open image ports
	_prtImgRgb.open(getName("rgb"));
	_prtImgActRgb.open(getName("out"));
	_prtBoundBoxes.open(getName("boundbox"));
	//printf("After port opening\n");
	imageCounter=1;
	return true;
}

bool WavingDetectorModule::close(){
	_prtImgRgb.close();
	_prtImgActRgb.close();
	_prtBoundBoxes.close();
	return true;
}

bool WavingDetectorModule::interruptModule(){

	_prtImgRgb.interrupt();
	_prtImgActRgb.interrupt();
	_prtBoundBoxes.interrupt();
	return true;
}

bool WavingDetectorModule::updateModule(){

	//yarp::sig::ImageOf<PixelRgb> *yrpImgIn;
	//printf("Entered update module\n");
	yarp::sig::ImageOf<PixelRgb> *yrpImgRgbIn = _prtImgRgb.read(false);
	//printf("update 1\n");
	if (yrpImgRgbIn != NULL){
		targetDetector.detection(*yrpImgRgbIn);
	//printf("update 2\n");
		if (!targetDetector.learningBackground){
			yarp::sig::ImageOf<PixelRgb> yrpImgOut(*yrpImgRgbIn);
			_currentImage = (IplImage*)yrpImgOut.getIplImage();
			ImageOf<PixelRgb>& yrpImgRgbOut = _prtImgActRgb.prepare();
			//drawDetectedBoxes(_currentImage,1,CV_RGB(255,0,255));
			//_currentImage = cvCloneImage( targetDetector.bestshiftsLXIPL );
			drawDetectedBoxes(_currentImage,1,CV_RGB(255,0,255));
				char fileName[100];
			/* Writing the result of the waving event to images */
			/*
			//sprintf( fileName, "/home/plinio/camera1/sequence%04d.jpg", imageCounter );
			sprintf( fileName, "H:/urus/tempWavint/video/sequence%04d.jpg", imageCounter );
			IplImage *copyImage= cvCreateImage( cvGetSize(_currentImage), _currentImage->depth, 3 );
			cvCopy(_currentImage,copyImage);
			IplImage* imageBGR = cvCreateImage( cvGetSize(copyImage), copyImage->depth, 3 );
			cvCvtColor( copyImage, imageBGR, CV_RGB2BGR );
			if (targetDetector._inverted_image)
				cvFlip( imageBGR, NULL, -1);
			cvSaveImage( fileName, imageBGR );
			cvReleaseImage(&imageBGR);
			cvReleaseImage(&copyImage);
			imageCounter++;
			*/
			yrpImgRgbOut = yrpImgOut;
			_prtImgActRgb.write();
			Matrix& boundingBoxes = _prtBoundBoxes.prepare();
			if (targetDetector.nTargFin>0){
			boundingBoxes.resize(4,targetDetector.nTargFin);
			//printf("number of targets: %d\n",targetDetector.nTargFin);
			for (int i=0; i < targetDetector.nTargFin ; i++){
				boundingBoxes[0][i]=targetDetector.BB[0][i]*targetDetector.blockSizeReduction;
				//printf ("xLeft: %f, ",boundingBoxes[0][i]);
				boundingBoxes[1][i]=targetDetector.BB[1][i]*targetDetector.blockSizeReduction;
				//printf ("yLeft: %f, ",boundingBoxes[1][i]);
				boundingBoxes[2][i]=targetDetector.BB[2][i]*targetDetector.blockSizeReduction;
				boundingBoxes[3][i]=targetDetector.BB[3][i]*targetDetector.blockSizeReduction;
				//printf ("width: %f, ",boundingBoxes[2][i]);
				//printf ("height: %f\n",boundingBoxes[3][i]);
			}
			_prtBoundBoxes.write();
			}
			
		}
	}
	return true;
	//return false;   // closing module
}

void WavingDetectorModule::drawDetectedBoxes(IplImage *currentImage, int lineThickness, CvScalar color){
	/*void drawBoundingBox(IplImage *currentImage, IplImage *imageCopy, 
	CvRect boundingBox, int lineThickness, CvScalar color)
	{*/
	CvPoint pt1, pt2, pt3;
	CvFont theFont;
	char myLabel[20];
	cvInitFont(&theFont, CV_FONT_VECTOR0, 0.5, 0.5, 0, lineThickness);
	CvScalar colorDetection = CvScalar(CV_RGB(0,255,0));
	for (int i=0; i < targetDetector.nTargFin ; i++){
		pt1.x = targetDetector.targets[i]->xLUPos;
		pt2.x = targetDetector.targets[i]->xRBPos;
		pt1.y = targetDetector.targets[i]->yLUPos;
		pt2.y = targetDetector.targets[i]->yRBPos;
		int detection=0;
		if (targetDetector.targets[i]->wavingEvent>0.0 && targetDetector.computeEventProbability)
			sprintf (&myLabel[0], "%d wave prob: %.2f", targetDetector.targets[i]->id,targetDetector.targets[i]->wavingEvent);
		else if (targetDetector.targets[i]->wavingEvent>0.0 && !targetDetector.computeEventProbability){
			sprintf (&myLabel[0], "%d waving", targetDetector.targets[i]->id);
			detection=1;
		}
		else
			sprintf (&myLabel[0], "%d", targetDetector.targets[i]->id);
		if (currentImage->nChannels==1){
			cvRectangle( currentImage, pt1, pt2, cvScalar(255), lineThickness, 8, 0 );
			cvPutText( currentImage, myLabel, pt2, &theFont, cvScalar(255) );
			//printf("got here\n");
		}
		else if (currentImage->nChannels==3){
			if (detection==1)
				cvRectangle( currentImage, pt1, pt2, colorDetection, lineThickness, 8, 0 );
			else
				cvRectangle( currentImage, pt1, pt2, color, lineThickness, 8, 0 );
			if (targetDetector._inverted_image){
				cvFlip( currentImage, NULL, -1);
				pt3.x = currentImage->width-pt1.x;
				pt3.y = currentImage->height-pt1.y;
				if (detection==1)
					cvPutText( currentImage, myLabel, pt3, &theFont, colorDetection );
				else
					cvPutText( currentImage, myLabel, pt3, &theFont, color );
				cvFlip( currentImage, NULL, -1);
			}
			else{
				if (detection==1)
					cvPutText( currentImage, myLabel, pt2, &theFont, colorDetection );
				else
					cvPutText( currentImage, myLabel, pt2, &theFont, color );
			}
		}
	}
}
