// -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*-

/*
 * Copyright (C) 2007 
 * CopyPolicy: Released under the terms of the GNU GPL v2.0.
 *
 */

#ifndef WAVINGDETECTOR_INC
#define WAVINGDETECTOR_INC

#include <vector>
#include <deque>
//yarp
#include <yarp/os/all.h>
#include <yarp/sig/all.h>

// opencv
#include <cv.h>
#include <cvSeqLabel.h>

/*#include "BTLocalMatcherT.h"
#include "OvFlowGlobalMatcherT.h"
//#include "OvFlowPostprocessor.h"
#include "OvFlowDiffuseMatcherT.h"
#include "OvFlowT.h"
#include "OvImageAdapter.h"
#include "OvImageT.h"
#include "OpenCVImageAdapter.h"*/
#include "OpenCVImageAdapter.h"
//#include "OvImageT.h"

//#include "OvImagePairPreprocessorT.h"
#include "OvLocalMatcherT.h"


#include "OvFlowGlobalMatcherT.h"
#include "OvFlowPostprocessor.h"

#include "OvFlowT.h"

#include "BTLocalMatcherT.h"
#include "OvFlowDiffuseMatcherT.h"
using namespace std;
using namespace yarp::os;
using namespace yarp::sig;
#define PI 3.1415926535897932384626433832795
class target{
public:
	target(){};
	target(int xLU, int yLU, int xRB, int yRB, int xC, int yC, int idN){xLUPos=xLU;yLUPos=yLU;xRBPos=xRB;yRBPos=yRB;id=idN;xCenter=xC;yCenter=yC;};
	target(int xLU, int yLU, int xRB, int yRB, int xC, int yC){xLUPos=xLU;yLUPos=yLU;xRBPos=xRB;yRBPos=yRB;xCenter=xC;yCenter=yC;};
	target(const target &t){
		xLUPos=t.xLUPos;
		yLUPos=t.yLUPos;
		xRBPos=t.xRBPos;
		xCenter=t.xCenter;
		yCenter=t.yCenter;
		id=t.id;
		wavingEvent=t.wavingEvent;
	}
	~target(){};
	int xLUPos;
	int yLUPos;
	int xRBPos;
	int yRBPos;
	int xCenter;
	int yCenter;
	int id;
	double wavingEvent;
};
class targetFeatures{
public:
	targetFeatures(){
		/*velX = deque <double>();
		velY = deque <double>();
		FOA = deque <vector<double>>();
		meanVelX = vector<double>(0,0.0);
		meanVelY = vector<double>(0,0.0);
		timeFilteredFOA = deque <vector<double> > ();
		wavingDetection = deque <int>();*/
		//optFlowX = vector<double>(0,0.0);
		//optFlowY = vector<double>(0,0.0);
	};
	targetFeatures(int temporalWindow){
		velX = deque <double>(temporalWindow,0.0);
		velY = deque <double>(temporalWindow,0.0);
		FOA = deque <vector<double> >(temporalWindow);
		/*meanVelX = vector<double>(temporalWindow,0.0);
		meanVelY = vector<double>(temporalWindow,0.0);
		optFlowX = vector<double>(temporalWindow,0.0);
		optFlowY = vector<double>(temporalWindow,0.0);*/
	};
	targetFeatures(const targetFeatures& t){
		id=t.id;
		FOA=t.FOA;
		wavingDetection=t.wavingDetection;
		velX=t.velX;
		velY=t.velY;
		timeFilteredFOA=t.timeFilteredFOA;
	}
	//~targetFeatures(){FOA.~deque();}
	~targetFeatures(){}
	int id;
	deque <double> velX;
	deque <double> velY;
	deque <vector<double> > FOA;
	deque <vector<double> > timeFilteredFOA;
	deque <int> wavingDetection;
	/*vector<double> meanVelX;
	vector<double> meanVelY;
	vector<double> optFlowX;
	vector<double> optFlowY;*/
};
typedef struct{
	int featureNumber;
	double threshold;
	double aWeight;
	double bWeight;
	int temporalWindow;
}weakLearner;
class temporalBoostClassifier{
public:
	temporalBoostClassifier(){};
	temporalBoostClassifier(int r){
		rounds=r;
	}
	~temporalBoostClassifier();
	int rounds;
	vector<weakLearner> weakLearners;
};
/**
 * Face detection module.
 */
class WavingDetector : public IConfig {
public:
	WavingDetector();
	virtual ~WavingDetector();
    virtual bool open(yarp::os::Searchable& config);
    virtual bool close();
	bool detection(const Image &in);
	bool init(CvSize currImgSize);
	bool detectWaving (int vectorPos);
	void meanFoaComputation(vector<double> *foaFeature,int vectorPos);
	void meanFoaComputationRecursive(vector<double> *foaFeature,int vectorPos);
	int *BB[4];
	int *BBactualSize[6];
	int nTargFin;
	bool learningBackground;
	int BBGreaterInd;
	int blockSizeReduction;
	bool definedTargets;
	int targetCounter;
	vector< target *> targets;
	vector< targetFeatures *> features;
	bool computeEventProbability;
	bool _inverted_image;
	//IplImage *bestshiftsLXIPL;
private:
	IplImage *LabelCopy;
	//Ipp8u
	IplImage  *Dif, *UB1, *UB2, *TH, *Ptd, *Dtr2,
	*FilhoBW, *Pai_high, *Pai_low, *Label, *im_pr,
	*bg1_pr, *bg2_pr, *TL, *Dtr; 
    int step_pt[1], stepS_pt[1], step1, step3, 
	step_pai, TOTAL_ELEMENTS, numLabels, nCol,
	lin, col, ind, *MinLin, *MaxLin, *MinCol, 
	*MaxCol, *Area, nAlvos, ind_alvo,
	ini, k, i, j, temp_i, dims[2], dims2[2], idmin, *matrixaux, countaux1, countaux2,countaux3;
	
    double aux1, a1, a2, a3, a4;		//auxiliar adaptation variables
	//Ipp64f
    IplImage pSum1,pSum2;//auxiliar QCC analisys
	int nAlvos_final;
	//IppiSize
    CvSize roi;// = {blockSizeReduction,blockSizeReduction};
	//IppiSize
    CvSize Tam, TamS, Tam2, Tam3, Tam4;
	//IppiRect
    CvRect rect2;
	bool needInit;
	bool backgroundNeedInit;
	int numberFramesBackgroundInit;
	int nFrames;
	IplImage *imgGray;
	IplImage *previousImgGray;
	IplImage * tempResult;
	IplImage *tempResult2;
	IplImage *myVal;
	IplConvKernel *structurant;
	IplImage *selectedPixelsAllTargets;
	CvMat *auxMat;
	CvRect auxRect;
	CvScalar sum1, sum2;
	int Sens, i_, j_, k_;
	bool Upgrade;
    int AreaMin;
    int AreaLow;
	int AreaGreater;
	double Adapt;
	int N;
	int updateCounter;
	int updateFrequency;
	int structurantSize;
	double **matrix;
	double dismin;
	double hungarianCost;
	double *hungarianAssingment;
	double *distMatrix;
	int *hungarianIDs;
	bool hungarianAlgorithm;
	BTLocalMatcherT<double> btmatcher; //birchfield-tomasi local matcher
    OvFlowDiffuseMatcherT<double> flowDiffuseMatcher; //diffuse flow global matcher
    OvFlowT<double> flowManager; //general optical flow algorithm execution manager
	double alphaOFMatch;
	double minshiftX;
	double maxshiftX;
	double minshiftY;
	double maxshiftY;
	/*IplImage *imgLeftIPL;
	IplImage *imgRightIPL;*/
	IplImage *bestshiftsLXIPL;
	IplImage *bestshiftsLYIPL;
	IplImage *occlLIPL;
	IplImage *bestshiftsRXIPL;
	IplImage *bestshiftsRYIPL;
	IplImage *occlRIPL;

	OpenCVImageAdapter *imgLeft;
	OpenCVImageAdapter *imgRight;
	OpenCVImageAdapter *bestshiftsLX;
	OpenCVImageAdapter *bestshiftsLY;
	OpenCVImageAdapter *occlL;
	OpenCVImageAdapter *bestshiftsRX;
	OpenCVImageAdapter *bestshiftsRY;
	OpenCVImageAdapter *occlR;
	bool previousImageNULL;
	BufferedPort<ImageOf<PixelFloat> >	_prtImgDebugMonoSigned;
	IplImage *_currentImage;
	int contTemp;
	vector<int> xPrevious;
	vector<int> yPrevious;
	int maxTemporalWindow;
	int meanTemporalWindow;
	int maxTemporalWindowWeakClassifier;
	int binsFOA;
	bool useSelectedPixels;
	temporalBoostClassifier *myClassifier;
	int windowEnlargement;
	int eventWindowSize;
	double windowDetectionRate;
	BufferedPort<Bottle> _prtWaving;
    //HOMOGRAPHY
    double _h11;
    double _h12;
    double _h13;
    double _h21;
    double _h22;
    double _h23;
    double _h31;
    double _h32;
    double _h33;
	int opticFlowSubSampling;
	
};

#endif
