// -*- mode:C++; tab-width:4; c-basic-offset:4; indent-tabs-mode:nil -*-

/*
* Copyright (C) 2007 
* CopyPolicy: Released under the terms of the GNU GPL v2.0.
*
*/

#include <ace/Time_Value.h>
#include <ace/Date_Time.h>
#include <sstream>
#include <WavingDetector.h>
#include <cv.h>
#include <highgui.h>

void assignmentoptimal(double *assignment, double *cost, double *distMatrix, int nOfRows, int nOfColumns);
void buildassignmentvector(double *assignment, bool *starMatrix, int nOfRows, int nOfColumns);
void computeassignmentcost(double *assignment, double *cost, double *distMatrix, int nOfRows);
void step2a(double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim);
void step2b(double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim);
void step3 (double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim);
void step4 (double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim, int row, int col);
void step5 (double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim);
int findIndexForFeature (vector< targetFeatures *> features, int searchId);
void foaComputation(vector<double> *foaFeature, IplImage *bestshiftsLX, IplImage *bestshiftsLY, IplImage *selectedPixels, int binsFOA, int xC, int yC);
WavingDetector::WavingDetector(){
}

WavingDetector::~WavingDetector(){
	close();
}

bool WavingDetector::open(Searchable &config){
	needInit = true;
	learningBackground = true;
	nFrames = 0;
	nAlvos_final=0;
	nTargFin = 0;
	backgroundNeedInit = true;
	if (config.check("help","if present, display usage message")) {
		printf("Call with --name /module_prefix --file configFile.ini\n");
		return false;
	}
	Bottle botConfig(config.toString().c_str());
	botConfig.setMonitor(config.getMonitor());
	bool group_found = false;
	Value *valGroup; // check assigns pointer to reference
	if(config.check("group", valGroup, "Configuration group to load module options from (string).")){
		ConstString strGroup = valGroup->asString().c_str();
		// is group a valid bottle?
		if (!config.findGroup(strGroup.c_str()).isNull()){
			botConfig.clear();
			botConfig.fromString(config.findGroup(strGroup.c_str(), string(ConstString("Loading configuration from group ") + strGroup).c_str()).toString().c_str());
			_h11 = botConfig.check("h11",1.0,"Homography: Line 1, Col 1").asDouble();
			_h12 = botConfig.check("h12",0.0,"Homography: Line 1, Col 2").asDouble();
			_h13 = botConfig.check("h13",0.0,"Homography: Line 1, Col 3").asDouble();
			_h21 = botConfig.check("h21",0.0,"Homography: Line 2, Col 1").asDouble();
			_h22 = botConfig.check("h22",1.0,"Homography: Line 2, Col 2").asDouble();
			_h23 = botConfig.check("h23",0.0,"Homography: Line 2, Col 3").asDouble();
			_h31 = botConfig.check("h31",0.0,"Homography: Line 3, Col 1").asDouble();
			_h32 = botConfig.check("h32",0.0,"Homography: Line 3, Col 2").asDouble();
			_h33 = botConfig.check("h33",1.0,"Homography: Line 3, Col 3").asDouble();
			_inverted_image = (botConfig.check("inverted_image",Value(0),"If the camera image is inverted, as if it's on the ceiling").asInt()!=0);
			group_found = true;
		}
	}
	if(!group_found){
		cout << endl << "\"--group\" command was not found or the group name inputed not found." << endl;
		//Default homography entries
		_h11 = config.check("h11",1.0,"Homography: Line 1, Col 1").asDouble();
		_h12 = config.check("h12",0.0,"Homography: Line 1, Col 2").asDouble();
		_h13 = config.check("h13",0.0,"Homography: Line 1, Col 3").asDouble();
		_h21 = config.check("h21",0.0,"Homography: Line 2, Col 1").asDouble();
		_h22 = config.check("h22",1.0,"Homography: Line 2, Col 2").asDouble();
		_h23 = config.check("h23",0.0,"Homography: Line 2, Col 3").asDouble();
		_h31 = config.check("h31",0.0,"Homography: Line 3, Col 1").asDouble();
		_h32 = config.check("h32",0.0,"Homography: Line 3, Col 2").asDouble();
		_h33 = config.check("h33",1.0,"Homography: Line 3, Col 3").asDouble();
		_inverted_image = (botConfig.check("inverted_image",Value(0),"If the camera image is inverted, as if it's on the ceiling").asInt()!=0);

	}
	Upgrade = (config.check("backgroundUpdate",
		Value(0),
		"Update the background").asInt()!=0);
	if (Upgrade){
		updateFrequency = config.check("updateFrequency",
			Value(256),
			"Update frequency").asInt();}
	AreaMin = config.check("areaMin", Value(50),
		"Minimum area treshold").asInt();
	AreaLow = config.check("areaLow", Value(3),
		"Minimun area treshold per bloc").asInt();
	Sens = config.check("sensitivity", Value(40),
		"Sensitivity parameter").asInt();
	Adapt = config.check("adapt", Value(0.078), "Background Adaptation parameter").asDouble();
	N = config.check("N", Value(4),"N").asInt();
	blockSizeReduction = config.check("blockSizeReduction", Value(4),"Block size reduction").asInt();
	numberFramesBackgroundInit = config.check("nFramesInit", Value(30), "Number of frames necessary to create the background model").asInt();
	structurantSize = config.check("structurantSize", Value(3), "Size of the structurant to joint areas next to each other").asInt();
	hungarianAlgorithm = (config.check("hungarianAlgorithm",
		Value(0),
		"option to select the hungarian algorithm for data association").asInt()!=0);
	alphaOFMatch = config.check("alphaOFMatch", Value(20), "threshold for Birchfield-Tomasi matching algorithm").asDouble();
	minshiftX = config.check("minshiftX", Value(-4), "minimum shift in X direction for the diffuse flow global matcher").asDouble();
	maxshiftX = config.check("maxshiftX", Value(4), "maximum shift in X direction for the diffuse flow global matcher").asDouble();
	minshiftY = config.check("minshiftY", Value(-4), "minimum shift in Y direction for the diffuse flow global matcher").asDouble();
	maxshiftY = config.check("maxshiftY", Value(4), "maximum shift in Y direction for the diffuse flow global matcher").asDouble();
	maxTemporalWindow = config.check("maxTemporalWindow", Value(5), "Maximum size of the temporal support of the features").asInt();
	meanTemporalWindow = config.check("meanTemporalWindow", Value(5), "Temporal support of the time-filtered features").asInt();
	binsFOA = config.check("binsFOA", Value(5), "Number of bins to compute the FOA feature vector").asInt();
	useSelectedPixels = (config.check("selectedPixels",
		Value(1),
		"option to compute the FOA using either the segmented pixels or the complete image").asInt()!=0);
	windowEnlargement= config.check("windowEnglargement", Value(10), "Value to enlarge the ROI for computing the optical flow").asInt();
	eventWindowSize=config.check("eventWindowSize", Value(10), "Temporal size of the waving event").asInt();
	windowDetectionRate=config.check("windowDetectionRate", Value(0.9), "Percentage of the positive dectections to fire an event").asDouble();
	opticFlowSubSampling=config.check("opticFlowSubSampling", Value(4), "Image subsampling for optical flow computation").asInt();
	computeEventProbability=(config.check("computeEventProbability",Value(0),"option to compute the event probability").asInt()!=0);
	//Bottle &bot = config.findGroup("weak_learner");
	Bottle bot(config.toString());
	myClassifier = new temporalBoostClassifier();
	//printf("bottle size: %d\n",bot.size());
	int numberOfClassifiers=0;
	maxTemporalWindowWeakClassifier=0;
	for(int i = 0; i < bot.size(); i++){//bot.size()

		Value &val = bot.get(i);
		Bottle *lstBot = val.asList();
		printf(val.asString());
		Property prop(lstBot->toString());

		if(prop.check("threshold")){
			weakLearner myLearner;
			myClassifier->weakLearners.push_back(myLearner);
			myClassifier->weakLearners[numberOfClassifiers].featureNumber = prop.find("featureNumber").asInt();
			myClassifier->weakLearners[numberOfClassifiers].threshold = prop.find("threshold").asDouble();
			myClassifier->weakLearners[numberOfClassifiers].aWeight = prop.find("aWeight").asDouble();
			myClassifier->weakLearners[numberOfClassifiers].bWeight = prop.find("bWeight").asDouble();
			myClassifier->weakLearners[numberOfClassifiers].temporalWindow = prop.find("temporalWindow").asInt();
			if ( myClassifier->weakLearners[numberOfClassifiers].temporalWindow > maxTemporalWindowWeakClassifier)
				maxTemporalWindowWeakClassifier = myClassifier->weakLearners[numberOfClassifiers].temporalWindow;
			numberOfClassifiers++;
		}
	}
	myClassifier->rounds=numberOfClassifiers;
	// Debug port to see the optical flow of every target
	//_prtImgDebugMonoSigned.open("/test/opticalFlow");
	_prtWaving.open("/data-feed/output/wave");
	return true;
}

bool WavingDetector::detection(const Image &in){
	if (needInit)
		init(cvSize(in.width(), in.height()));
	cvCvtColor((IplImage*)in.getIplImage(),imgGray, CV_RGB2GRAY);//imgGray now contains gray scale image
	if ( backgroundNeedInit ){
		cvCopy( imgGray, bg1_pr );
		cvCopy( imgGray, bg2_pr );
		backgroundNeedInit = false;
	}
	/* Background estimation */
	if ( learningBackground && nFrames < numberFramesBackgroundInit ){
		for (int na = 0; na < in.height(); na++) {
			for (int ma = 0; ma < in.width(); ma++) {
				if ( cvGet2D( imgGray, na, ma ).val[0] > cvGet2D( bg1_pr, na, ma ).val[0])
					cvSet2D( bg1_pr, na, ma, cvGet2D( imgGray, na, ma ) );
				if ( cvGet2D( imgGray, na, ma ).val[0] < cvGet2D( bg2_pr, na, ma ).val[0])
					cvSet2D( bg2_pr, na, ma, cvGet2D( imgGray, na, ma ) );
			}

		}
		cvAbsDiff( bg1_pr, bg2_pr, TL );
		nFrames++;
		if ( nFrames == numberFramesBackgroundInit )
			learningBackground = false;
	}
	else{
		/* timestamp for the data fusion algorithm */
		std::string timeString;
		{
			ACE_Time_Value t = ACE_OS::gettimeofday();
			std::stringstream ss;
			ss.fill('0');
			ss << t.sec();
			ss << ":";
			ss.fill('0');
			ss.width(6);
			ss << t.usec();
			timeString = ss.str();
		}
		cvAbsDiff( bg1_pr, imgGray, Dtr );
		cvAbsDiff( bg2_pr, imgGray, Dif );
		cvCmp( Dtr, Dif, UB1, CV_CMP_LE );
		cvNot( UB1, UB2 );
		cvAnd( UB1, Dtr, Dtr );
		cvAnd( UB2, Dif, Dif );
		// ADDS MASKED BGs
		cvAdd( Dtr, Dif, Dif, NULL );
		// COMPARE MASKED BGs #2 WITH LOWER THRESHOLD
		cvCmp( Dif, TL, Dtr, CV_CMP_GT );
		// CREATES HIGHER THRESHOLDS
		cvAddS( TL, cvScalar(Sens), TH, NULL );

		// COMPARE MASKED BGs #2 WITH HIGHER THRESHOLD
		cvCmp( Dif, TH, Dtr2, CV_CMP_GT );
		// ********** QUASI-CONNECTED COMPONENTS **********
		cvSetZero(Pai_low);
		cvSetZero(Pai_high);

		k_=0;
		for (j_=0; j_<dims2[0]; j_++)
		{				
			for ( i_=0; i_<dims2[1]; i_++)
			{
				auxRect= cvRect(i_*blockSizeReduction,j_*blockSizeReduction,blockSizeReduction,blockSizeReduction);
				auxMat=cvGetSubRect( Dtr, auxMat, auxRect );
				sum1=cvSum( auxMat );
				if ( sum1.val[0] < AreaLow * 255) Pai_low->imageData[k_]=(unsigned char) 0;
				else Pai_low->imageData[k_]=(unsigned char) (sum1.val[0]/255); //original
				auxMat=cvGetSubRect( Dtr2, auxMat, auxRect );
				sum2=cvSum( auxMat );
				if ( sum2.val[0] == 0 ) Pai_high->imageData[k_]=(unsigned char) 0;
				else Pai_high->imageData[k_]=(unsigned char) 255;
				k_++;
			}
		}
		cvDilate( Pai_high, Pai_high, structurant, 1 );
		cvAnd( Pai_low, Pai_high, Pai_high, NULL );
		cvSetZero(Label);
		numLabels = cvSeqLabel( Pai_high, Label);
		cvCopy(Label, LabelCopy);

		// ********** Computation of the bounding boxes of the detections **********
		if (numLabels)
		{
			// warning: compiler requested cast
			// NOTE: consider alloc of fixed size in init()
			MinLin =(int *) malloc( sizeof(int)*numLabels);
			MaxLin =(int *) malloc( sizeof(int)*numLabels);
			MinCol =(int *) malloc( sizeof(int)*numLabels);
			MaxCol =(int *) malloc( sizeof(int)*numLabels);
			Area =(int *) malloc( sizeof(int)*numLabels);
			for (ind=0; ind<numLabels;ind++)
			{
				MinLin[ind] = dims2[0];
				MaxLin[ind] = 0;
				MinCol[ind] = dims2[1];
				MaxCol[ind] = 0;
				Area[ind] = 0;
			}
			for (ind=0; ind < dims2[0]*dims2[1]; ind++)
			{
				if (Label->imageData[ind])
				{				
					lin=(int)floor((double) ind/dims2[1] ) +1;
					col=( ind - ( lin-1 )*dims2[1] ) +1;
					if (lin < MinLin[Label->imageData[ind]-1]){
						MinLin[Label->imageData[ind]-1] = lin;}
					if (lin > MaxLin[Label->imageData[ind]-1]){
						MaxLin[Label->imageData[ind]-1] = lin;}
					if (col < MinCol[Label->imageData[ind]-1]){
						MinCol[Label->imageData[ind]-1] = col;}
					if (col > MaxCol[Label->imageData[ind]-1]){
						MaxCol[Label->imageData[ind]-1] = col;}
					Area[Label->imageData[ind]-1] = Area[Label->imageData[ind]-1] + Pai_high->imageData[ind];
					Label->imageData[ind]=(unsigned char)255;
				} // if (Label...
			} // for (ind=0...
		} // if (numLabels...
		//printf("before bb init\n");
		nAlvos_final=0;
		for (ind=0;ind<numLabels; ind++){
			if (Area[ind] >= AreaMin){
				nAlvos_final++;}}

		BB[0]= (int *) malloc (sizeof(int)*nAlvos_final);
		BB[1]= (int *) malloc (sizeof(int)*nAlvos_final);
		BB[2]= (int *) malloc (sizeof(int)*nAlvos_final);
		BB[3]= (int *) malloc (sizeof(int)*nAlvos_final);
		BB[4]= (int *) malloc (sizeof(int)*nAlvos_final);

		BBactualSize[0]= (int *) malloc (sizeof(int)*nAlvos_final);
		BBactualSize[1]= (int *) malloc (sizeof(int)*nAlvos_final);
		BBactualSize[2]= (int *) malloc (sizeof(int)*nAlvos_final);
		BBactualSize[3]= (int *) malloc (sizeof(int)*nAlvos_final);
		BBactualSize[4]= (int *) malloc (sizeof(int)*nAlvos_final);
		BBactualSize[5]= (int *) malloc (sizeof(int)*nAlvos_final);

		nTargFin=0;
		AreaGreater=0;
		BBGreaterInd=-1;
		for (ind=0;ind<numLabels; ind++)
		{
			if (Area[ind] >= AreaMin)
			{
				BB[0][nTargFin] = MinCol[ind]-1;
				BBactualSize[0][nTargFin]=BB[0][nTargFin]*blockSizeReduction;
				BB[1][nTargFin] = MinLin[ind]-1;
				BBactualSize[1][nTargFin]=BB[1][nTargFin]*blockSizeReduction;
				BB[2][nTargFin] = MaxCol[ind]-MinCol[ind]+1;
				BBactualSize[2][nTargFin]=BBactualSize[0][nTargFin]+BB[2][nTargFin]*blockSizeReduction;
				BB[3][nTargFin] = MaxLin[ind]-MinLin[ind]+1;			
				BBactualSize[3][nTargFin]=BBactualSize[1][nTargFin]+BB[3][nTargFin]*blockSizeReduction;
				BBactualSize[4][nTargFin]=(BB[2][nTargFin]/2+BB[0][nTargFin])*blockSizeReduction;
				BBactualSize[5][nTargFin]=(BB[3][nTargFin]/2+BB[1][nTargFin])*blockSizeReduction;
				if (Area[ind]>AreaGreater)
				{
					AreaGreater=Area[ind];
					BBGreaterInd=nTargFin;
				}
				nTargFin++;
			}
		}
		cvResize( Label, FilhoBW, CV_INTER_NN );
		cvAnd(FilhoBW,FilhoBW,selectedPixelsAllTargets);
		if (!definedTargets){
			//printf("1\n");
			for (ind=0;ind<nTargFin; ind++){
				target *currentTracker = new target(BBactualSize[0][ind],BBactualSize[1][ind],BBactualSize[2][ind],BBactualSize[3][ind],BBactualSize[4][ind],BBactualSize[5][ind],ind);
				targets.push_back(currentTracker);
				targetFeatures *tempFeatures = new targetFeatures();
				features.push_back(tempFeatures);
				features[ind]->id=targetCounter;
				targetCounter++;
			}
			if (nTargFin>0){
				definedTargets=true;
				xPrevious = vector<int>(nTargFin,-1);
				yPrevious = vector<int>(nTargFin,-1);
			}
		}
		/* Distance matrix computation for proximity tracker */
		int *matrixIndexes;
		matrix = (double **)malloc(sizeof(double)*nTargFin);
		distMatrix = (double *)malloc(sizeof(double)*targets.size()*nTargFin);
		for (int na = 0; na < nTargFin; na++)
			matrix[na] = (double *)malloc(sizeof(double)*targets.size()*2);
		int myCount;
		if (xPrevious.size()>0)
			xPrevious.clear();
		if (yPrevious.size()>0)
			yPrevious.clear();
		xPrevious = vector<int>(targets.size(),-1);
		yPrevious = vector<int>(targets.size(),-1);
		for (int na = 0; na < nTargFin; na++) {
			for (int ma = 0, myCount=0; ma < targets.size()*2; ma=ma+2,myCount++) {
				xPrevious[myCount]=targets[myCount]->xCenter;
				yPrevious[myCount]=targets[myCount]->yCenter;
				matrix[na][ma] = sqrt((double)((BBactualSize[4][na]-targets[myCount]->xCenter)*(BBactualSize[4][na]-targets[myCount]->xCenter) 
					+ (BBactualSize[5][na]-targets[myCount]->yCenter)*(BBactualSize[5][na]-targets[myCount]->yCenter)));
				distMatrix[myCount*nTargFin+na] = matrix[na][ma];
				matrix[na][ma+1] = targets[myCount]->id;
			}
		}
		/* data association start */
		/* Hungarian assigment algorithm for tracking */
		if (hungarianAlgorithm){
			hungarianAssingment = (double *)malloc(sizeof(double)*nTargFin);
			hungarianIDs = (int *)malloc(sizeof(int)*nTargFin);
			assignmentoptimal(hungarianAssingment, &hungarianCost, distMatrix, nTargFin, targets.size());
			int cT1;
			int initSize=features.size();
			vector< target *>::iterator initTarget=targets.begin();
			//vector< targetFeatures *>::iterator initFeature=features.begin();
			for (int cT=0,cT1=0;cT<initSize;cT++){
				//targetFeatures *myCurrFeature=
				int currIndex = features[cT1]->id;
				bool found=false;
				for (int na = 0; na < nTargFin; na++){
					if (hungarianAssingment[na]!=-1){
						target *tempTarget=*(initTarget+(int)hungarianAssingment[na]);
						//if (targets[(int)hungarianAssingment[na]]->id==currIndex)
						if (tempTarget->id==currIndex)
							found=true;
					}
				}
				//printf("feature id: %d found: %d cT:%d cT1:%d initSize : %d ",currIndex,found,cT,cT1,initSize);
				if (!found){
					features.erase(features.begin()+cT1);
				}
				else
					cT1++;

			}
			//printf("\n");
			//printf("After assigning tracks\n");
			for (int na = 0; na < nTargFin; na++){
				int additionalCopy=0;
				//printf("na: %d\n",na);
				//targetFeatures *tempFeatures = new targetFeatures();
				if (hungarianAssingment[na]==-1.0){
					//printf("if not assigned start\n");
					hungarianIDs[na]=targetCounter;
					targetFeatures *tempFeatures = new targetFeatures();
					//printf("features size: %d\n",features.size());
					tempFeatures->id = targetCounter;
					features.push_back(tempFeatures);
					vector< targetFeatures *>::iterator endFeature=features.end();
					targetFeatures *tempFeat=*(endFeature-1);
					//printf("features size: %d  na: %d targetCounter: %d id:%d idFromVector:%d \n",features.size(),na,targetCounter,tempFeatures->id,tempFeat->id);
					//features[features.size()-1]->id=targetCounter;
					//printf("target counter: %d\n",targetCounter);
					targetCounter++;
					//printf("if not assigned end\n");
					/*if (additionalCopy>0){
						targetFeatures *tempFeatures1 = new targetFeatures();
						features.push_back(tempFeatures1);
					}
					additionalCopy++;*/
					//additionalCopy=true;
				}
				else{
					//printf("if assigned start na: %d\n",na);
					//printf("targets size: %d\n",targets.size());
					target *tempTarget=*(initTarget+(int)hungarianAssingment[na]);
					//hungarianIDs[na]=targets[(int)hungarianAssingment[na]]->id;
					hungarianIDs[na]=tempTarget->id;
					//printf("hungarianIDs[%d]: %d\n",na,hungarianIDs[na]);
					//printf("1\n");
					//printf("features size: %d\n",features.size());
					int vectorPos = findIndexForFeature (features, hungarianIDs[na]);
					//printf("vectorPos: %d\n",vectorPos);
					//printf("2\n");
					//features[vectorPos]->velX.push_front(BBactualSize[4][na]-targets[(int)hungarianAssingment[na]]->xCenter);
					features[vectorPos]->velX.push_front(BBactualSize[4][na]-tempTarget->xCenter);
					//printf("3\n");
					if (features[vectorPos]->velX.size()>maxTemporalWindow)
						features[vectorPos]->velX.pop_back();
					//printf("4\n");
					features[vectorPos]->velY.push_front(BBactualSize[5][na]-tempTarget->yCenter);
					//printf("5\n");
					if (features[vectorPos]->velY.size()>maxTemporalWindow)
						features[vectorPos]->velY.pop_back();
					//printf("if assign end\n");
				}
			}
			//printf("After assigning features\n");
			/*if (targets.size()>0)
				targets.clear();
			for (int na = 0; na < nTargFin; na++) {
				target *currentTracker = new target(BBactualSize[0][na],BBactualSize[1][na],BBactualSize[2][na],BBactualSize[3][na],BBactualSize[4][na],BBactualSize[5][na],hungarianIDs[na]);
				targets.push_back(currentTracker);
			}
			int cT1;
			for (int cT=0,cT1=0;cT<features.size();cT++){
				int currIndex = features[cT1]->id;
				bool found=false;
				for (int na = 0; na < nTargFin; na++){
					if (hungarianAssingment[na]!=-1)
						if (targets[(int)hungarianAssingment[na]]->id==currIndex)
							found=true;
				}
				if (!found){
					features.erase(features.begin()+cT1);
				}
				else
					cT1++;

			}*/
		}
		/* nearest neighbor algorithm for tracking */
		else{
			matrixaux = (int *)malloc(sizeof(int)*nTargFin);
			matrixIndexes = (int *)malloc(sizeof(int)*nTargFin);
			for (int na = 0; na < nTargFin; na++)
				matrixaux[na] = -1;
			for (int la = 0; la < nTargFin; la++) {
				dismin = 1000;
				int indPos;
				for (int na = 0; na < nTargFin; na++) {
					for (int ma = 0,indPos=0; ma < targets.size()*2; ma = ma+2,indPos++) {
						if (dismin > matrix[na][ma]) {
							dismin = matrix[na][ma];			
							idmin = matrix[na][ma+1];
							countaux1 = ma;
							countaux2 = na;
							countaux3 = indPos;
						}
					}
				}
				if (dismin < 100) {
					for (int na = 0; na < nTargFin; na++)
						matrix[na][countaux1] = 1000;
					for (int ma = 0; ma < targets.size()*2; ma = ma+2)
						matrix[countaux2][ma] = 1000;
					matrixaux[countaux2] = idmin;
					matrixIndexes[countaux2] = countaux3;
				}	    

			}
			int cT1;
			for (int cT=0,cT1=0;cT<features.size();cT++){
				int currIndex = features[cT1]->id;
				bool found=false;
				for (int na = 0; na < nTargFin; na++){
					if (matrixaux[na]!=-1)
						if (matrixaux[na]==currIndex)
							found=true;
				}
				if (!found){
					features.erase(features.begin()+cT1);
				}
				else
					cT1++;

			}
			for (int na = 0; na < nTargFin; na++) {
				if (matrixaux[na] == -1){
					matrixaux[na] = targetCounter;
					targetFeatures *tempFeatures = new targetFeatures();
					features.push_back(tempFeatures);
					features[features.size()-1]->id=targetCounter;
					targetCounter++;
				}
				else {
					int vectorPos = findIndexForFeature (features, matrixaux[na]);
					features[vectorPos]->velX.push_front(BBactualSize[4][na]-targets[matrixIndexes[na]]->xCenter);
					if (features[vectorPos]->velX.size()>maxTemporalWindow)
						features[vectorPos]->velX.pop_back();
					features[vectorPos]->velY.push_front(BBactualSize[5][na]-targets[matrixIndexes[na]]->yCenter);
					if (features[vectorPos]->velY.size()>maxTemporalWindow)
						features[vectorPos]->velY.pop_back();
				}
			}
			/*
			if (targets.size()>0)
				targets.clear();
			for (int na = 0; na < nTargFin; na++) {
				target *currentTracker = new target(BBactualSize[0][na],BBactualSize[1][na],BBactualSize[2][na],BBactualSize[3][na],BBactualSize[4][na],BBactualSize[5][na],matrixaux[na]);
				targets.push_back(currentTracker);
			}*/
		}
		/* data association end */
		//printf("Before cleaning the targets\n");
		if (targets.size()>0)
			targets.clear();
		for (int na = 0; na < nTargFin; na++) {
			if (hungarianAlgorithm){
				//printf("target id[%d]: %d  ",na,hungarianIDs[na]);
				target *currentTracker = new target(BBactualSize[0][na],BBactualSize[1][na],BBactualSize[2][na],BBactualSize[3][na],BBactualSize[4][na],BBactualSize[5][na],hungarianIDs[na]);
				targets.push_back(currentTracker);
			}
			else{
				target *currentTracker = new target(BBactualSize[0][na],BBactualSize[1][na],BBactualSize[2][na],BBactualSize[3][na],BBactualSize[4][na],BBactualSize[5][na],matrixaux[na]);
				targets.push_back(currentTracker);
			}
		}
		/* Condition to compute the optical flow */
		if (!previousImageNULL){
			if (targets.size()>0){
				/* Compute FOA and store for every target -- start*/
				for(int ii=0; ii < targets.size(); ii++){
					int xLeft,yLeft,xRight,yRight,windowHeight,windowWidth;
					if(targets[ii]->xLUPos-windowEnlargement<0)
						xLeft=0;
					else
						xLeft=targets[ii]->xLUPos-windowEnlargement;
					if(targets[ii]->yLUPos-windowEnlargement<0)
						yLeft=0;
					else
						yLeft=targets[ii]->yLUPos-windowEnlargement;

					if (xLeft+(targets[ii]->xRBPos-targets[ii]->xLUPos)+2*windowEnlargement>imgGray->width){
						xRight=imgGray->width;
						windowWidth=imgGray->width-xLeft;
					}
					else
					{
						xRight=xLeft+(targets[ii]->xRBPos-targets[ii]->xLUPos)+2*windowEnlargement;
						windowWidth=xRight-xLeft;
					}
					if (yLeft+(targets[ii]->yRBPos-targets[ii]->yLUPos)+2*windowEnlargement>imgGray->height){
						yRight=imgGray->height;
						windowHeight=imgGray->height-yLeft;
					}
					else
					{
						yRight=yLeft+(targets[ii]->yRBPos-targets[ii]->yLUPos)+2*windowEnlargement;
						windowHeight=yRight-yLeft;
					}
					//Initial version of the code
					//CvRect rect_Eye1 = cvRect(targets[ii]->xLUPos, targets[ii]->yLUPos, targets[ii]->xRBPos-targets[ii]->xLUPos, targets[ii]->yRBPos-targets[ii]->yLUPos);
					//Version with enlarged window
					CvRect rect_Eye1 = cvRect(xLeft, yLeft, windowWidth, windowHeight);

					//Initial version of the code
					//CvSize currentSize = cvSize(targets[ii]->xRBPos-targets[ii]->xLUPos, targets[ii]->yRBPos-targets[ii]->yLUPos);
					//Version with enlarged window
					CvSize currentSize = cvSize(windowWidth, windowHeight);
					IplImage *selectedImage;
					IplImage *selectedPixels;
					if (useSelectedPixels)
						selectedPixels = cvCreateImage(currentSize, IPL_DEPTH_8U, 1);
					else
						selectedPixels = NULL;
					selectedImage=cvCreateImage(currentSize, IPL_DEPTH_8U, 1);
					IplImage *selectedImagePrevious;
					selectedImagePrevious=cvCreateImage(currentSize,   IPL_DEPTH_8U, 1);
					int contx,conty;
					//Initial version of the code
					/*for (int na = targets[ii]->yLUPos,contx=0; na < targets[ii]->yRBPos; na++,contx++) {
					for (int ma = targets[ii]->xLUPos,conty=0; ma < targets[ii]->xRBPos; ma++,conty++) {*/
					//Version with the enlarged window
					if(_inverted_image){
						for (int na = yRight-1,contx=0; na >= yLeft; na--,contx++) {
							for (int ma = xRight-1,conty=0; ma >= xLeft; ma--,conty++) {
								//for (int ma = xLeft,conty=0; ma < xRight; ma++,conty++) {
								cvSet2D( selectedImage, contx, conty, cvGet2D( imgGray, na, ma ) );
								cvSet2D( selectedImagePrevious, contx, conty, cvGet2D( previousImgGray, na, ma ) );
								if (useSelectedPixels)
									cvSet2D( selectedPixels, contx, conty, cvGet2D( selectedPixelsAllTargets, na, ma ) );
							}
						}
					}
					else{
						for (int na = yLeft,contx=0; na < yRight; na++,contx++) {
							for (int ma = xLeft,conty=0; ma < xRight; ma++,conty++) {
								cvSet2D( selectedImage, contx, conty, cvGet2D( imgGray, na, ma ) );
								cvSet2D( selectedImagePrevious, contx, conty, cvGet2D( previousImgGray, na, ma ) );
								if (useSelectedPixels)
									cvSet2D( selectedPixels, contx, conty, cvGet2D( selectedPixelsAllTargets, na, ma ) );
							}
						}
					}
					vector<double> foaFeature = vector<double>(binsFOA*2,0.0);
					/*Option to compute the optical flow in a subsampled image*/
					if (opticFlowSubSampling!=0){
						IplImage *subsampledSelectedImage;
						IplImage *subsampledSelectedPreviousImage;
						IplImage *subsampledSelectedPixels;

                                                int subWidth=(int) floor((double)windowWidth/(double)opticFlowSubSampling);
                                                int subHeight=(int) floor((double)windowHeight/(double)opticFlowSubSampling);
						CvSize subsampledSize = cvSize(subWidth, subHeight);
						subsampledSelectedImage=cvCreateImage(subsampledSize,  IPL_DEPTH_8U, 1);
						cvResize( selectedImage, subsampledSelectedImage, CV_INTER_LINEAR );
						subsampledSelectedPreviousImage=cvCreateImage(subsampledSize,  IPL_DEPTH_8U, 1);
						cvResize( selectedImagePrevious, subsampledSelectedPreviousImage, CV_INTER_LINEAR );
						subsampledSelectedPixels=cvCreateImage(subsampledSize,  IPL_DEPTH_8U, 1);
						cvResize( selectedPixels, subsampledSelectedPixels, CV_INTER_LINEAR );
						CvMoments myMoments;
						double currentXc=(double)subWidth/2;//compute the Xc in box center
						double currentYc=(double)subHeight/2;//compute the Yc in box center
						/*Option to compute the Xc and Yc in the center of mass*/
						if (useSelectedPixels){
							cvMoments( subsampledSelectedPixels, &myMoments);
							currentXc = cvGetSpatialMoment( &myMoments, 1, 0 )/cvGetSpatialMoment( &myMoments, 0, 0 );
							currentYc = cvGetSpatialMoment( &myMoments, 0, 1 )/cvGetSpatialMoment( &myMoments, 0, 0 );
						}
						imgLeft  = new OpenCVImageAdapter(subsampledSelectedPreviousImage);
						imgRight = new OpenCVImageAdapter(subsampledSelectedImage);
						/*imgLeft  = new OpenCVImageAdapter((IplImage *)Eye2Image);
						imgRight = new OpenCVImageAdapter((IplImage *)Eye1Image);*/
						bestshiftsLXIPL = cvCreateImage(subsampledSize,  IPL_DEPTH_64F, 1);
						bestshiftsLYIPL = cvCreateImage(subsampledSize,  IPL_DEPTH_64F, 1);
						occlLIPL = cvCreateImage(subsampledSize,  IPL_DEPTH_64F, 1);
						bestshiftsRXIPL = cvCreateImage(subsampledSize,  IPL_DEPTH_64F, 1);
						bestshiftsRYIPL = cvCreateImage(subsampledSize,  IPL_DEPTH_64F, 1);
						occlRIPL = cvCreateImage(subsampledSize,  IPL_DEPTH_64F, 1);

						bestshiftsLX = new OpenCVImageAdapter(bestshiftsLXIPL);
						bestshiftsLY = new OpenCVImageAdapter(bestshiftsLYIPL);
						occlL = new OpenCVImageAdapter(occlLIPL);
						bestshiftsRX = new OpenCVImageAdapter(bestshiftsRXIPL);
						bestshiftsRY = new OpenCVImageAdapter(bestshiftsRYIPL);
						occlR = new OpenCVImageAdapter(occlRIPL);
						/* optical flow computation */
						flowManager.doOpticalFlow(*imgLeft, *imgRight, minshiftX, maxshiftX, minshiftY, maxshiftY, *bestshiftsLX, *bestshiftsLY, *occlL, *bestshiftsRX, *bestshiftsRY, *occlR);
						/* FOA feature computation */
						foaComputation(&foaFeature, bestshiftsLXIPL, bestshiftsLYIPL, selectedPixels, binsFOA, (int)currentXc, (int)currentYc);
						cvReleaseImage(&subsampledSelectedImage);
						cvReleaseImage(&subsampledSelectedPreviousImage);
						cvReleaseImage(&subsampledSelectedPixels);

					}
					/* Option to compute the optical flow in the actual image size */
					else{
						CvMoments myMoments;
						double currentXc=(double)targets[ii]->xCenter;//compute the Xc in the case of not selectedPixels
						double currentYc=(double)targets[ii]->yCenter;
						if (useSelectedPixels){
							cvMoments( selectedPixels, &myMoments);
							currentXc = cvGetSpatialMoment( &myMoments, 1, 0 )/cvGetSpatialMoment( &myMoments, 0, 0 );
							currentYc = cvGetSpatialMoment( &myMoments, 0, 1 )/cvGetSpatialMoment( &myMoments, 0, 0 );
						}
						imgLeft  = new OpenCVImageAdapter(selectedImagePrevious);
						imgRight = new OpenCVImageAdapter(selectedImage);
						/*imgLeft  = new OpenCVImageAdapter((IplImage *)Eye2Image);
						imgRight = new OpenCVImageAdapter((IplImage *)Eye1Image);*/
						bestshiftsLXIPL = cvCreateImage(currentSize,  IPL_DEPTH_64F, 1);
						bestshiftsLYIPL = cvCreateImage(currentSize,  IPL_DEPTH_64F, 1);
						occlLIPL = cvCreateImage(currentSize,  IPL_DEPTH_64F, 1);
						bestshiftsRXIPL = cvCreateImage(currentSize,  IPL_DEPTH_64F, 1);
						bestshiftsRYIPL = cvCreateImage(currentSize,  IPL_DEPTH_64F, 1);
						occlRIPL = cvCreateImage(currentSize,  IPL_DEPTH_64F, 1);

						bestshiftsLX = new OpenCVImageAdapter(bestshiftsLXIPL);
						bestshiftsLY = new OpenCVImageAdapter(bestshiftsLYIPL);
						occlL = new OpenCVImageAdapter(occlLIPL);
						bestshiftsRX = new OpenCVImageAdapter(bestshiftsRXIPL);
						bestshiftsRY = new OpenCVImageAdapter(bestshiftsRYIPL);
						occlR = new OpenCVImageAdapter(occlRIPL);
						/* optical flow computation */
						flowManager.doOpticalFlow(*imgLeft, *imgRight, minshiftX, maxshiftX, minshiftY, maxshiftY, *bestshiftsLX, *bestshiftsLY, *occlL, *bestshiftsRX, *bestshiftsRY, *occlR);
						/* FOA feature computation */
						foaComputation(&foaFeature, bestshiftsLXIPL, bestshiftsLYIPL, selectedPixels, binsFOA, (int)currentXc, (int)currentYc);
					}
					/* Add the FOA computed to the correspondent features of the current target */
					int vectorPos = findIndexForFeature (features,targets[ii]->id);
					targets[ii]->wavingEvent=0.0;
					//printf("Feature vector size before adding FOA: %d\n",features.size());
					features[vectorPos]->FOA.push_front(foaFeature);
					if (features[vectorPos]->FOA.size()<=meanTemporalWindow){
						vector<double> meanfoaFeature = vector<double>(binsFOA*2,0.0);
						meanFoaComputation(&meanfoaFeature,vectorPos);
						features[vectorPos]->timeFilteredFOA.push_front(foaFeature);
					}
					else{
						vector<double> meanfoaFeature = vector<double>(binsFOA*2,0.0);
						meanFoaComputationRecursive(&meanfoaFeature, vectorPos);
						features[vectorPos]->timeFilteredFOA.push_front(foaFeature);
						features[vectorPos]->timeFilteredFOA.pop_back();
					}
					if (features[vectorPos]->FOA.size()>maxTemporalWindow)
						features[vectorPos]->FOA.pop_back();
					//printf("Feature vector size after adding FOA: %d\n",features.size());
					/* Necessary condition to compute the classification */
					if (features[vectorPos]->FOA.size()>=maxTemporalWindowWeakClassifier){
						//call the classfier
						bool detectionResult = detectWaving(vectorPos);
						if (detectionResult){
							printf("The %d target is waving\n",targets[ii]->id);
							features[vectorPos]->wavingDetection.push_front(1);
						}
						else{
							features[vectorPos]->wavingDetection.push_front(0);
							printf("The %d target is not waving\n",targets[ii]->id);
						}
						/* detection of the waving event */
						if (features[vectorPos]->wavingDetection.size()>eventWindowSize)
							features[vectorPos]->wavingDetection.pop_back();
						if (features[vectorPos]->wavingDetection.size()==eventWindowSize){
							double numberOfDetections=0.0;
							for (int contEvent=0;contEvent<features[vectorPos]->wavingDetection.size();contEvent++)
								numberOfDetections+=features[vectorPos]->wavingDetection[contEvent];
							/* Option to compute the event as a binary decision */
							if (!computeEventProbability){
								if (numberOfDetections > (double)eventWindowSize*windowDetectionRate ){
									printf("WAVING EVENT!! of target %d\n",targets[ii]->id);
									targets[ii]->wavingEvent=1.0;
									/* Compute and send the location of the waving event */
									double px,py,x,y;
									if(_inverted_image){
										px = (double)targets[ii]->xCenter;
										py = (double)targets[ii]->yLUPos;
									}else{	    
										px= (double)targets[ii]->xCenter;
										py = (double)targets[ii]->yRBPos;
									}
									x = (_h11*px + _h12*py+_h13)/(_h31*px+_h32*py+_h33);
									y = (_h21*px + _h22*py+_h23)/(_h31*px+_h32*py+_h33);
									Bottle &b_person_waving = _prtWaving.prepare();
									b_person_waving.addString(timeString.c_str());
									b_person_waving.addDouble(x);
									b_person_waving.addDouble(y);
									b_person_waving.addDouble(1.0);
									_prtWaving.write();
								}
							}
							/* Option to compute the event probability */
							else{
								double eventProbability=numberOfDetections/(double)eventWindowSize;
								targets[ii]->wavingEvent=eventProbability;
								printf("Target %d is waving with a probability of: %f\n",targets[ii]->id,eventProbability);
								/* Compute and send the location of the waving event */
								double px,py,x,y;
								if(_inverted_image){
									px = (double)targets[ii]->xCenter;
									py = (double)targets[ii]->yLUPos;
								}else{	    
									px= (double)targets[ii]->xCenter;
									py = (double)targets[ii]->yRBPos;
								}
								x = (_h11*px + _h12*py+_h13)/(_h31*px+_h32*py+_h33);
								y = (_h21*px + _h22*py+_h23)/(_h31*px+_h32*py+_h33);
								Bottle &b_person_waving = _prtWaving.prepare();
								b_person_waving.addString(timeString.c_str());
								b_person_waving.addDouble(x);
								b_person_waving.addDouble(y);
								b_person_waving.addDouble(eventProbability);
								_prtWaving.write();
							}
						}

					}
					/* Compute FOA and store for every target -- end*/
					yarp::sig::ImageOf<PixelFloat> yrpImgOut;
					yrpImgOut.resize(currentSize.width,currentSize.height);
					_currentImage = (IplImage*)yrpImgOut.getIplImage();
					delete imgLeft;
					delete imgRight;
					delete bestshiftsLX;
					delete bestshiftsLY;
					delete occlL;
					delete bestshiftsRX;
					delete bestshiftsRY;
					delete occlR;
					cvReleaseImage (&selectedImage);
					if (useSelectedPixels)
						cvReleaseImage (&selectedPixels);
					cvReleaseImage(&selectedImagePrevious);
					cvReleaseImage(&bestshiftsLXIPL);
					cvReleaseImage(&bestshiftsLYIPL);
					cvReleaseImage(&occlLIPL);
					cvReleaseImage(&bestshiftsRXIPL);
					cvReleaseImage(&bestshiftsRYIPL);
					cvReleaseImage(&occlRIPL);
					//printf("After computing optical flow\n");
				}
			}
		}



		// ********** OPTIONAL UPDATES **********
		if (Upgrade && updateCounter == updateFrequency)
		{
			updateCounter=0;
			// ********** UPDATE THRESHOLDS **********				
			cvAnd(FilhoBW, Dtr, Ptd);

			for (i_; i_<dims[0]*dims[1]; i_++)
			{
				if (Dtr->imageData[i_])
				{
					if ( (!Ptd->imageData[i_]) & (TL->imageData[i_]<246) )
					{
						TL->imageData[i_]=TL->imageData[i_]+10;
					}
				}
				else
				{
					if ( TL->imageData[i_]!=0 )
					{
						TL->imageData[i_]=TL->imageData[i_]-1;
					}
				}
			}

			// ********** UPDATE BACKGROUNDS **********
			for ( i_=0; i_<dims[0]*dims[1]; i_++)
			{
				if (UB1->imageData[i_])
				{
					if (Ptd->imageData[i_])
					{
						//aux1= a4 * bgL1g->imageData[i_] + a3 * Lg->imageData[i_];
						aux1= a4 * (double)((unsigned char)bg1_pr->imageData[i_]) + a3 * (double)((unsigned char)imgGray->imageData[i_]);
					}
					else
					{
						//aux1= a2 * bgL1g->imageData[i_] + a1 * Lg->imageData[i_];
						aux1= a2 * (double)((unsigned char)bg1_pr->imageData[i_]) + a1 * (double)((unsigned char)imgGray->imageData[i_]);
					}
					bg1_pr->imageData[i_]= (unsigned char) (aux1+0.5);
				}
				else
				{
					if (Ptd->imageData[i_])
					{
						//aux1= a4 * bgL2g->imageData[i_] + a3 * Lg->imageData[i_];
						aux1= a4 * (double)((unsigned char)bg2_pr->imageData[i_]) + a3 * (double)((unsigned char)imgGray->imageData[i_]);
					}
					else
					{
						//aux1= a2 * bgL2g->imageData[i_] + a1 * Lg->imageData[i_];
						aux1= a2 * (double)((unsigned char)bg2_pr->imageData[i_]) + a1 * (double)((unsigned char)imgGray->imageData[i_]);
					}
					bg2_pr->imageData[i_]= (unsigned char) (aux1+0.5);
				}
			}
			//printf("update done\n");
		}
		cvCopy( imgGray, previousImgGray);//previousImgGray = cvCloneImage( imgGray );
		previousImageNULL=false;
		//printf("free 1\n");
		free(BB[0]);
		free(BB[1]);
		free(BB[2]);
		free(BB[3]);
		//printf("free 2\n");
		free(BBactualSize[0]);
		free(BBactualSize[1]);
		free(BBactualSize[2]);
		free(BBactualSize[3]);
		free(BBactualSize[4]);
		free(BBactualSize[5]);
		//printf("free 3\n");
		contTemp++;
		double *temp;
		for (int na = 0; na < nTargFin; na++){
			temp = matrix[na];
			free(temp);
		}
		//printf("free 4\n");
		free(matrix);
		//printf("free 4.1\n");
		free(distMatrix);
		//printf("free 5\n");
		if (hungarianAlgorithm){
			//printf("Before releasing hungarian assingment memory\n");
			free(hungarianAssingment);
			//printf("After step 1\n");
			free(hungarianIDs);
			//printf("After step 2\n");
		}
		else
		{
			free(matrixIndexes);
			free(matrixaux);
		}
		//printf("end detection\n");
		updateCounter++;
	}
	return true;
}

bool WavingDetector::init(CvSize currImgSize){
	TamS.width=currImgSize.width/blockSizeReduction;	//for small size imges
	TamS.height=currImgSize.height/blockSizeReduction;	//for small size imges
	Dif = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);			//DIFFERENCE IMAGE
	UB1 = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);		
	UB2 = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);			
	TH = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);			// HIGH TRESHOLD
	Ptd= cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	Dtr2 = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	FilhoBW = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	selectedPixelsAllTargets = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	Pai_low = cvCreateImage(TamS, IPL_DEPTH_8U, 1);
	Pai_high = cvCreateImage(TamS, IPL_DEPTH_8U, 1);

	Label = cvCreateImage(TamS, IPL_DEPTH_8U, 1);
	bg1_pr = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	bg2_pr = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	im_pr = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	TL = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	Dtr = cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);

	imgGray=cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	previousImgGray=cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	tempResult=cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	tempResult2=cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	myVal=cvCreateImage(currImgSize,  IPL_DEPTH_8U, 1);
	cvSet( TL, cvScalar(30), 0 );

	//auxMat=NULL;
	auxMat= cvCreateMat(blockSizeReduction,blockSizeReduction,cvGetElemType( Dif ));
	// CvRect
	auxRect=cvRect(0,0,0,0);

	dims2[0]=currImgSize.height/blockSizeReduction;   
	dims2[1]=currImgSize.width/blockSizeReduction;
	dims[0]=currImgSize.height;   
	dims[1]=currImgSize.width;
	// CvScalar
	sum1=cvScalar(0);
	sum2=cvScalar(0);
	Label = cvCreateImage( TamS, 8, 1 );
	LabelCopy = cvCreateImage( TamS, 8, 1 );
	a1=Adapt;
	a2=(1-Adapt);
	a3=Adapt/N;
	a4=a2+a1*(N-1)/N;
	aux1=0;
	needInit=false;
	updateCounter=1;
	int anchor=(structurantSize-1)/2;
	structurant = cvCreateStructuringElementEx( structurantSize, structurantSize, anchor, anchor, CV_SHAPE_RECT, NULL );
	definedTargets = false;
	targetCounter = 0;
	btmatcher.setParams(1,&alphaOFMatch);
	flowManager.setLocalImageMatcher(btmatcher); //set to use birchfield-tomasi matcher
	flowManager.setGlobalMatcher(flowDiffuseMatcher); //set global algo to diffuse matching
	previousImageNULL=true;
	return true;
}

bool WavingDetector::close(){
	cvReleaseImage (&Dif);
	cvReleaseImage (&UB1);		
	cvReleaseImage (&UB2);			
	cvReleaseImage (&TH);			
	cvReleaseImage (&Ptd);
	cvReleaseImage (&Dtr2);
	cvReleaseImage (&FilhoBW);
	cvReleaseImage (&Pai_low);
	cvReleaseImage (&Pai_high);

	cvReleaseImage (&Label);
	cvReleaseImage (&bg1_pr);
	cvReleaseImage (&bg2_pr);
	cvReleaseImage (&im_pr);
	cvReleaseImage (&TL);
	cvReleaseImage (&Dtr);

	cvReleaseImage (&imgGray);
	cvReleaseImage (&tempResult);
	cvReleaseStructuringElement( &structurant );
	cvReleaseImage( &previousImgGray);
	cvReleaseImage( &selectedPixelsAllTargets);
	/////_prtImgDebugMonoSigned.close();
	_prtWaving.close();
	contTemp=0;
	return true;
}

/********************************************************/
void step3(double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim)
{
	bool zerosFound;
	int row, col, starCol;

	zerosFound = true;
	while(zerosFound)
	{
		zerosFound = false;		
		for(col=0; col<nOfColumns; col++)
			if(!coveredColumns[col])
				for(row=0; row<nOfRows; row++)
					if((!coveredRows[row]) && (distMatrix[row + nOfRows*col] == 0))
					{
						/* prime zero */
						primeMatrix[row + nOfRows*col] = true;

						/* find starred zero in current row */
						for(starCol=0; starCol<nOfColumns; starCol++)
							if(starMatrix[row + nOfRows*starCol])
								break;

						if(starCol == nOfColumns) /* no starred zero found */
						{
							/* move to step 4 */
							step4(assignment, distMatrix, starMatrix, newStarMatrix, primeMatrix, coveredColumns, coveredRows, nOfRows, nOfColumns, minDim, row, col);
							return;
						}
						else
						{
							coveredRows[row]        = true;
							coveredColumns[starCol] = false;
							zerosFound              = true;
							break;
						}
					}
	}

	/* move to step 5 */
	step5(assignment, distMatrix, starMatrix, newStarMatrix, primeMatrix, coveredColumns, coveredRows, nOfRows, nOfColumns, minDim);
}
/********************************************************/
void buildassignmentvector(double *assignment, bool *starMatrix, int nOfRows, int nOfColumns)
{
	int row, col;

	for(row=0; row<nOfRows; row++)
		for(col=0; col<nOfColumns; col++)
			if(starMatrix[row + nOfRows*col])
			{
				assignment[row] = col;
				break;
			}
}
/********************************************************/
void step2b(double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim)
{
	int col, nOfCoveredColumns;

	/* count covered columns */
	nOfCoveredColumns = 0;
	for(col=0; col<nOfColumns; col++)
		if(coveredColumns[col])
			nOfCoveredColumns++;

	if(nOfCoveredColumns == minDim)
	{
		/* algorithm finished */
		buildassignmentvector(assignment, starMatrix, nOfRows, nOfColumns);
	}
	else
	{
		/* move to step 3 */
		step3(assignment, distMatrix, starMatrix, newStarMatrix, primeMatrix, coveredColumns, coveredRows, nOfRows, nOfColumns, minDim);
	}

}

void assignmentoptimal(double *assignment, double *cost, double *distMatrixIn, int nOfRows, int nOfColumns)
{
	double *distMatrix, *distMatrixTemp, *distMatrixEnd, *columnEnd, value, minValue;
	bool *coveredColumns, *coveredRows, *starMatrix, *newStarMatrix, *primeMatrix;
	int nOfElements, minDim, row, col;

	/* initialization */
	*cost = 0;
	for(row=0; row<nOfRows; row++)
		assignment[row] = -1.0;

	/* generate working copy of distance Matrix */
	/* check if all matrix elements are positive */
	nOfElements   = nOfRows * nOfColumns;
	distMatrix    = (double *)malloc(nOfElements * sizeof(double));
	distMatrixEnd = distMatrix + nOfElements;
	for(row=0; row<nOfElements; row++)
	{
		value = distMatrixIn[row];
		if(value < 0)
			printf("All matrix elements have to be non-negative.");
		distMatrix[row] = value;
	}
	/* memory allocation */
	coveredColumns = (bool *)calloc(nOfColumns,  sizeof(bool));
	coveredRows    = (bool *)calloc(nOfRows,     sizeof(bool));
	starMatrix     = (bool *)calloc(nOfElements, sizeof(bool));
	primeMatrix    = (bool *)calloc(nOfElements, sizeof(bool));
	newStarMatrix  = (bool *)calloc(nOfElements, sizeof(bool)); /* used in step4 */

	/* preliminary steps */
	if(nOfRows <= nOfColumns)
	{
		minDim = nOfRows;

		for(row=0; row<nOfRows; row++)
		{
			/* find the smallest element in the row */
			distMatrixTemp = distMatrix + row;
			minValue = *distMatrixTemp;
			distMatrixTemp += nOfRows;			
			while(distMatrixTemp < distMatrixEnd)
			{
				value = *distMatrixTemp;
				if(value < minValue)
					minValue = value;
				distMatrixTemp += nOfRows;
			}

			/* subtract the smallest element from each element of the row */
			distMatrixTemp = distMatrix + row;
			while(distMatrixTemp < distMatrixEnd)
			{
				*distMatrixTemp -= minValue;
				distMatrixTemp += nOfRows;
			}
		}

		/* Steps 1 and 2a */
		for(row=0; row<nOfRows; row++)
			for(col=0; col<nOfColumns; col++)
				if(distMatrix[row + nOfRows*col] == 0)
					if(!coveredColumns[col])
					{
						starMatrix[row + nOfRows*col] = true;
						coveredColumns[col]           = true;
						break;
					}
	}
	else /* if(nOfRows > nOfColumns) */
	{
		minDim = nOfColumns;

		for(col=0; col<nOfColumns; col++)
		{
			/* find the smallest element in the column */
			distMatrixTemp = distMatrix     + nOfRows*col;
			columnEnd      = distMatrixTemp + nOfRows;

			minValue = *distMatrixTemp++;			
			while(distMatrixTemp < columnEnd)
			{
				value = *distMatrixTemp++;
				if(value < minValue)
					minValue = value;
			}

			/* subtract the smallest element from each element of the column */
			distMatrixTemp = distMatrix + nOfRows*col;
			while(distMatrixTemp < columnEnd)
				*distMatrixTemp++ -= minValue;
		}

		/* Steps 1 and 2a */
		for(col=0; col<nOfColumns; col++)
			for(row=0; row<nOfRows; row++)
				if(distMatrix[row + nOfRows*col] == 0)
					if(!coveredRows[row])
					{
						starMatrix[row + nOfRows*col] = true;
						coveredColumns[col]           = true;
						coveredRows[row]              = true;
						break;
					}
					for(row=0; row<nOfRows; row++)
						coveredRows[row] = false;

	}	

	/* move to step 2b */
	step2b(assignment, distMatrix, starMatrix, newStarMatrix, primeMatrix, coveredColumns, coveredRows, nOfRows, nOfColumns, minDim);

	/* compute cost and remove invalid assignments */
	computeassignmentcost(assignment, cost, distMatrixIn, nOfRows);

	/* free allocated memory */
	free(distMatrix);
	free(coveredColumns);
	free(coveredRows);
	free(starMatrix);
	free(primeMatrix);
	free(newStarMatrix);

	return;
}



/********************************************************/
void computeassignmentcost(double *assignment, double *cost, double *distMatrix, int nOfRows)
{
	int row, col;

	for(row=0; row<nOfRows; row++)
	{
		col = assignment[row];
		if(col >= 0)
		{
			*cost += distMatrix[row + nOfRows*col];
		}
	}
}

/********************************************************/
void step2a(double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim)
{
	bool *starMatrixTemp, *columnEnd;
	int col;

	/* cover every column containing a starred zero */
	for(col=0; col<nOfColumns; col++)
	{
		starMatrixTemp = starMatrix     + nOfRows*col;
		columnEnd      = starMatrixTemp + nOfRows;
		while(starMatrixTemp < columnEnd){
			if(*starMatrixTemp++)
			{
				coveredColumns[col] = true;
				break;
			}
		}	
	}

	/* move to step 3 */
	step2b(assignment, distMatrix, starMatrix, newStarMatrix, primeMatrix, coveredColumns, coveredRows, nOfRows, nOfColumns, minDim);
}




/********************************************************/
void step4(double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim, int row, int col)
{	
	int n, starRow, starCol, primeRow, primeCol;
	int nOfElements = nOfRows*nOfColumns;

	/* generate temporary copy of starMatrix */
	for(n=0; n<nOfElements; n++)
		newStarMatrix[n] = starMatrix[n];

	/* star current zero */
	newStarMatrix[row + nOfRows*col] = true;

	/* find starred zero in current column */
	starCol = col;
	for(starRow=0; starRow<nOfRows; starRow++)
		if(starMatrix[starRow + nOfRows*starCol])
			break;

	while(starRow<nOfRows)
	{
		/* unstar the starred zero */
		newStarMatrix[starRow + nOfRows*starCol] = false;

		/* find primed zero in current row */
		primeRow = starRow;
		for(primeCol=0; primeCol<nOfColumns; primeCol++)
			if(primeMatrix[primeRow + nOfRows*primeCol])
				break;

		/* star the primed zero */
		newStarMatrix[primeRow + nOfRows*primeCol] = true;

		/* find starred zero in current column */
		starCol = primeCol;
		for(starRow=0; starRow<nOfRows; starRow++)
			if(starMatrix[starRow + nOfRows*starCol])
				break;
	}	

	/* use temporary copy as new starMatrix */
	/* delete all primes, uncover all rows */
	for(n=0; n<nOfElements; n++)
	{
		primeMatrix[n] = false;
		starMatrix[n]  = newStarMatrix[n];
	}
	for(n=0; n<nOfRows; n++)
		coveredRows[n] = false;

	/* move to step 2a */
	step2a(assignment, distMatrix, starMatrix, newStarMatrix, primeMatrix, coveredColumns, coveredRows, nOfRows, nOfColumns, minDim);
}

/********************************************************/
void step5(double *assignment, double *distMatrix, bool *starMatrix, bool *newStarMatrix, bool *primeMatrix, bool *coveredColumns, bool *coveredRows, int nOfRows, int nOfColumns, int minDim)
{
	double h, value;
	int row, col;

	/* find smallest uncovered element h */
	h = 100000;//mxGetInf();	
	for(row=0; row<nOfRows; row++)
		if(!coveredRows[row])
			for(col=0; col<nOfColumns; col++)
				if(!coveredColumns[col])
				{
					value = distMatrix[row + nOfRows*col];
					if(value < h)
						h = value;
				}

				/* add h to each covered row */
				for(row=0; row<nOfRows; row++)
					if(coveredRows[row])
						for(col=0; col<nOfColumns; col++)
							distMatrix[row + nOfRows*col] += h;

				/* subtract h from each uncovered column */
				for(col=0; col<nOfColumns; col++)
					if(!coveredColumns[col])
						for(row=0; row<nOfRows; row++)
							distMatrix[row + nOfRows*col] -= h;

				/* move to step 3 */
				step3(assignment, distMatrix, starMatrix, newStarMatrix, primeMatrix, coveredColumns, coveredRows, nOfRows, nOfColumns, minDim);
}

int findIndexForFeature (vector< targetFeatures *> features, int searchId)
{
	for (int nn=0;nn<features.size();nn++)
		if (features[nn]->id == searchId)
			return nn;
	return -1;
}

void foaComputation(vector<double> *foaFeature, IplImage *bestshiftsLX, IplImage *bestshiftsLY, IplImage *selectedPixels, int binsFOA, int xC, int yC)
{
	vector<double> nPixelsPerDirection(binsFOA,0.0);
	vector<double> foaFeatureNotProjected(binsFOA*2,0.0);
	/*printf("height: %d\n",bestshiftsLX->height);
	printf("width: %d\n",bestshiftsLX->width);
	printf("yC: %d\n",yC);
	printf("xC: %d\n",xC);*/
	for (int na = 0; na < bestshiftsLX->height; na++) {
		for (int ma = 0; ma < bestshiftsLX->width; ma++) {
			//cvSet2D( _currentImage, na, ma, cvGet2D( bestshiftsLXIPL, na, ma ) );
			CvScalar a = cvGet2D( bestshiftsLX, na, ma );
			CvScalar b = cvGet2D( bestshiftsLY, na, ma );
			double currentAngle = atan2((double)(yC-na),(double)(ma-xC));
			//printf("angle: %f ",currentAngle*180/PI);
			if ( selectedPixels==NULL ){
				for (int currBin=0;currBin<binsFOA;currBin++){
					//printf("bin[%d]: %f \n",currBin,(-PI+currBin*PI/((double)binsFOA/2))*180/PI);
					//printf("bin[%d]: %f \n",currBin,(-PI+(currBin+1)*PI/((double)binsFOA/2))*180/PI);
					if ( currentAngle > (-PI+currBin*PI/((double)binsFOA/2)) && currentAngle <= (-PI+(currBin+1)*PI/((double)binsFOA/2)) ){
						foaFeatureNotProjected[currBin*2]+=a.val[0];
						foaFeatureNotProjected[currBin*2+1]+=b.val[0];
						nPixelsPerDirection[currBin]=nPixelsPerDirection[currBin]+1;
						currBin=binsFOA;
					}
				}
			}
			else {
				CvScalar c = cvGet2D( selectedPixels, na, ma );
				//if (c.val[0]==255){
				//printf("in\n");
				for (int currBin=0;currBin<binsFOA;currBin++){
					//printf("bin[%d]: %f \n",currBin,(-PI+currBin*PI/((double)binsFOA/2))*180/PI);
					//printf("bin[%d]: %f \n",currBin,(-PI+(currBin+1)*PI/((double)binsFOA/2))*180/PI);
					if ( currentAngle > (-PI+currBin*PI/((double)binsFOA/2)) && currentAngle <= (-PI+(currBin+1)*PI/((double)binsFOA/2)) ){
						foaFeatureNotProjected[currBin*2]+=a.val[0];
						foaFeatureNotProjected[currBin*2+1]+=b.val[0];
						nPixelsPerDirection[currBin]=nPixelsPerDirection[currBin]+1;
						currBin=binsFOA;
					}
				}
				//}
			}
		}
	}
	for (int currBin=0;currBin<binsFOA;currBin++){
		double radialDirection = cos(-PI+currBin*PI/((double)binsFOA/2)+PI/((double)binsFOA));
		double normalDirection = sin(-PI+currBin*PI/((double)binsFOA/2)+PI/((double)binsFOA));
		//printf("direction[%d]: %f\n",currBin, (-PI+currBin*PI/((double)binsFOA/2)+PI/((double)binsFOA))*180/PI);
		if (nPixelsPerDirection[currBin]>0){
			foaFeatureNotProjected[currBin*2]=foaFeatureNotProjected[currBin*2]/nPixelsPerDirection[currBin];
			//printf("FoaFeature: %f\n",(*foaFeature)[currBin*2]);
			foaFeatureNotProjected[currBin*2+1]=foaFeatureNotProjected[currBin*2+1]/nPixelsPerDirection[currBin];
			(*foaFeature)[currBin*2] = foaFeatureNotProjected[currBin*2]*radialDirection+foaFeatureNotProjected[currBin*2+1]*normalDirection;
			if (fabs((*foaFeature)[currBin*2])<0.0000001)
				(*foaFeature)[currBin*2]=0;
			//printf("FoaFeature: %f\n",(*foaFeature)[currBin*2]);
			(*foaFeature)[currBin*2+1] = (-1.0)*foaFeatureNotProjected[currBin*2]*normalDirection+foaFeatureNotProjected[currBin*2+1]*radialDirection;
			if (fabs((*foaFeature)[currBin*2+1])<0.0000001)
				(*foaFeature)[currBin*2+1]=0;
			//printf("FoaFeature: %f\n",(*foaFeature)[currBin*2]);
		}
		else{
			(*foaFeature)[currBin*2]=0;
			(*foaFeature)[currBin*2+1]=0;
		}
	}
}
bool WavingDetector::detectWaving (int vectorPos)
{
	double FM=0.0;
	for (int ii=0;ii< myClassifier->rounds;ii++ ){
		double chi=0.0,phi=0.0,fm=0.0;
		for (int time=0;time < myClassifier->weakLearners[ii].temporalWindow;time++){
			//for (int ndata=0;ndata<features[vectorPos]->FOA[0].size();ndata++){
			if ( features[vectorPos]->FOA[time][myClassifier->weakLearners[ii].featureNumber-1]>myClassifier->weakLearners[ii].threshold ){
				phi++;
			}
			else
				chi++;

			//}
		}
		//printf("chi: %f\n",chi);
		//printf("phi: %f\n",phi);
		chi/=(double)myClassifier->weakLearners[ii].temporalWindow;
		phi/=(double)myClassifier->weakLearners[ii].temporalWindow;
		//printf("chi: %f, phi: %f, temporalWindow: %d\n",chi,phi,myClassifier->weakLearners[ii].temporalWindow);
		//printf("phi: %f\n",phi);
		fm=myClassifier->weakLearners[ii].aWeight*phi+myClassifier->weakLearners[ii].bWeight*chi;
		//printf("fm: %f\n",fm);
		FM+=fm;
		//printf("fm: %f, FM: %f\n",fm,FM);
	}
	//printf("Classification result: %f\n",FM);
	if (FM>0)
		return true;
	else if (FM<0)
		return false;
}
void WavingDetector::meanFoaComputation(vector<double> *foaFeature,int vectorPos)
{
	for (int mm=0;mm<features[vectorPos]->FOA[0].size();mm++){
		for (int nn=0;nn<features[vectorPos]->FOA.size();nn++){
			(*foaFeature)[mm]+=features[vectorPos]->FOA[nn][mm];
		}
		(*foaFeature)[mm]/=features[vectorPos]->FOA.size();
	}
}

void WavingDetector::meanFoaComputationRecursive(vector<double> *foaFeature,int vectorPos)
{
	int mySize=features[vectorPos]->FOA.size();
	for (int mm=0;mm<features[vectorPos]->FOA[0].size();mm++){
		//for (int nn=0;nn<features[vectorPos]->FOA.size();nn++){
		//	(*foaFeature)[mm]+=features[vectorPos]->FOA[nn][mm];
		//}
		(*foaFeature)[mm]=features[vectorPos]->timeFilteredFOA[0][mm]-features[vectorPos]->FOA[mySize-1][mm]/(features[vectorPos]->FOA.size()-1)+features[vectorPos]->FOA[0][mm]/(features[vectorPos]->FOA.size()-1);
	}
}
