function [result,recRate,recRateCL,Fx]=StrongJointTemporalBoost(x,classifier,Nclass,Nrounds,label)

Nsamples=length(x);
Fx = zeros(Nclass, Nsamples);
for m = 1:Nrounds
%     disp(sprintf('Round %d', m))  
    % Weak regression stump: It is defined by four parameters (a,b,k,th)
    %     f_m = a * (x_k > th) + b 
    % update parameters classifier
    featureNdx=classifier(m).featureNdx;
    th = classifier(m).th ;
    a = classifier(m).a ;
    b= classifier(m).b;
    kc = classifier(m).kc ;
    ClassSet = classifier(m).ClassSet;
    NegClassSet = classifier(m).NegClassSet;
    T = classifier(m).T;
    
    
    PHI=filter(ones(1,T)/T,1,x(featureNdx,:)>th);
    CHI=1-PHI;
    
%     for i = T:Nsamples
%         PHI(i) = length( find( x(featureNdx,i-T+1:i) > th ) )/T;
%         
%         CHI(i) = length( find( x(featureNdx,i-T+1:i) <= th ) )/T;
%     end

    for CL=1:Nclass
        % Updating and computing classifier output on training samples
        if ~isempty(find(CL==ClassSet))
            fm(CL,:) = (a *PHI + b*CHI); % evaluate weak classifier
        else
            fm(CL,:) = repmat(kc(CL),1,Nsamples);
        end
    end
    Fx = Fx + fm; % update strong classifier
    [val result]=max(Fx,[],1);
%     Cx=sign(Fx);
    hits=[];
    for CL=1:Nclass
        indCL=find(label==CL);
        NumLab(CL)=length(indCL);
        NumCorr(CL)=length(find(result(indCL)==CL));
        RecRateClass(CL)=NumCorr(CL)/NumLab(CL);
    end
    recRateCL(m)=sum(RecRateClass)/Nclass;
    recRate(m)=sum(NumCorr)/sum(NumLab);
%     plot(Fx')
%     title(['Round n' sprintf('%d',m)])
%     drawnow
%     pause(.2);
%     hits(m) = length(find(Cx.*y<0))/length(Cx);
%     Fx(find(Fx>1))=1;Fx(find(Fx<-1))=-1;
%     hits(m) =1/Nsamples*sum(abs((y - Fx)/2));
    % Reweight training samples
%     w = w .* exp(-zMat.*fm);

end
