function [classifier,Fx,classEst] = JointTemporalBoostC(x, y, Nrounds,TS,Combinations)
% gentleBoost
%
% features x
% class: y = [-1,1]
%
% Implementation of jointBoost:
% plinio&pedro, 2006

[Nfeatures, Nsamples] = size(x); % Nsamples = Number of thresholds that we will consider
%CREATE THE LABEL MATRIX & weights MATRIX FOR THE JOINTBOOST
Nclass = max(y);
w  = ones(Nclass, Nsamples);
Fx = zeros(Nclass, Nsamples);
zMat=repmat(y,Nclass,1);
for cl=1:Nclass
    onesLoc=(zMat(cl,:)==cl);
    negLoc=not(onesLoc);
    zMat(cl, :)=onesLoc-negLoc;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%

for m = 1:Nrounds
    disp(sprintf('Round %d', m))  
    % Weak regression stump: It is defined by four parameters (a,b,k,th)
    %     f_m = a * (x_k > th) + b 
    [featureNdx, th, a , b, kc ,T, ClassSet, NegClassSet, error] = selectBestJointTemporalDecisionStumpC(x, zMat, w,TS,y,Combinations); %JOINT BOOSTING ----

    % update parameters classifier
    classifier(m).featureNdx = featureNdx;
    classifier(m).th = th;
    classifier(m).a  = a;
    classifier(m).b  = b;
    classifier(m).kc  = kc;
    classifier(m).ClassSet = ClassSet;
    classifier(m).NegClassSet = NegClassSet;
    classifier(m).T=T;
    
    for i = T:Nsamples
        PHI(i) = length( find( x(featureNdx,i-T+1:i) > th ) )/T;
        CHI(i) = length( find( x(featureNdx,i-T+1:i) <= th ) )/T;
    end

    for CL=1:Nclass
        % Updating and computing classifier output on training samples
        if ~isempty(find(CL==ClassSet))
            fm(CL,:) = (a *PHI + b*CHI); % evaluate weak classifier
        else
            fm(CL,:) = repmat(kc(CL),1,Nsamples);
        end
    end
    Fx = Fx + fm; % update strong classifier
    [val classEst]=max(Fx,[],1);
%     Cx=sign(Fx);
    hits=[];
%     hits(m) = length(find(Cx.*y<0))/length(Cx);
%     Fx(find(Fx>1))=1;Fx(find(Fx<-1))=-1;
%     hits(m) =1/Nsamples*sum(abs((y - Fx)/2));
    % Reweight training samples
    w = w .* exp(-zMat.*fm);
    w=w./sum(sum(w));
end

