%the l2Boost

% B = P^-1 * s
% P = X' * X
% s = X' * U

function [P s J F B]=L2BoostWC_onLine_Cw(X,y,POld,sOld,feat,shr)
[Ndata,Nfeat]=size(X);
XX=X;
%number of rounds
M=size(sOld,2);
B=zeros(Nfeat,M);
%for round 1 use the optimized feature
X=XX(:,[feat(1),end]);
%adaptation variables
PNew = X'*X;
%compute the new P for the used feature
P(:,:,feat(1))=POld(:,:,feat(1))+PNew;
Pinv = P(:,:,feat(1))^-1;
sNew(:,1) = X'*y;
s(:,1)=sOld(:,1)+sNew(:,1);
%linear model parameters
B_(:,1) = Pinv*s*shr;
B([feat(1),end],1) = B_(:,1);
F(:,1) = XX*B(:,1);
f(:,1) = F(:,1);
F(:,1) = sign(F(:,1)).*min(1,abs(F(:,1)));
J(1)=sum((y-F(:,1)).^2)/(2*Ndata);
for m=1:M-1
    u(:,m) = y-F(:,m);
    X=XX(:,[feat(m+1),end]);
    PNew = X'*X;
    %compute the new P for the used feature
    P(:,:,feat(m+1))=POld(:,:,feat(m+1))+PNew;
    sNew(:,m+1) = X'*u(:,m);
    s(:,m+1)=sOld(:,m+1)+sNew(:,m+1);
    Pinv = P(:,:,feat(m+1))^-1;
    B_(:,m+1) = Pinv*s(:,m+1)*shr;
    B([feat(m+1),end],m+1) = B_(:,m+1);
    f(:,m+1) = XX*B(:,m+1);
    F(:,m+1) = sign(F(:,m) + f(:,m+1)).*min(1,abs(F(:,m) + f(:,m+1)));
    J(m+1)=sum((y-F(:,m+1)).^2)/(2*Ndata);
end
