%the l2Boost

% B = P^-1 * s
% P = X' * X
% s = X' * U

function [P s J F B u]=L2BoostWC_onLine(X,y,POld,sOld)
[Ndata,Nfeat]=size(X);
%number of rounds
M=size(sOld,2);
%adaptation variables
PNew = X'*X;
P=POld+PNew;
Pinv = P^-1;
sNew(:,1) = X'*y;
s(:,1)=sOld(:,1)+sNew(:,1);
%linear model parameters
B(:,1) = Pinv*s;
F(:,1) = X*B(:,1);
f(:,1) = F(:,1);
F(:,1) = sign(F(:,1)).*min(1,abs(F(:,1)));
J(1)=sum((y-F(:,1)).^2)/(2*Ndata);
for m=1:M-1
    u(:,m) = y-F(:,m);
    sNew(:,m+1) = X'*u(:,m);
    s(:,m+1)=sOld(:,m+1)+sNew(:,m+1);
    
    B(:,m+1) = Pinv*s(:,m+1);
    f(:,m+1) = X*B(:,m+1);
    F(:,m+1) = sign(F(:,m) + f(:,m+1)).*min(1,abs(F(:,m) + f(:,m+1)));
    J(m+1)=sum((y-F(:,m+1)).^2)/(2*Ndata);
end
