%the l2Boost

% B = P^-1 * s
% P = X' * X
% s = X' * U

function [P s J F B u]=L2BoostWC_offLine_Shrinkage(X,y,M,shr)
[Ndata,Nfeat]=size(X);
u=[];
%adaptation variables
P = (X'*X);
Pinv = P^-1;
s(:,1) = X'*y;
%linear model parameters
B(:,1) = Pinv*s*shr;
F(:,1) = X*B(:,1);
f(:,1) = F(:,1);
F(:,1) = sign(F(:,1)).*min(1,abs(F(:,1)));
J(1)=sum((y-F(:,1)).^2)/(2*Ndata);
for m=1:M-1
    u(:,m) = y-F(:,m);
    s(:,m+1) = X'*u(:,m);
    B(:,m+1) = Pinv*s(:,m+1)*shr;
    f(:,m+1) = X*B(:,m+1);
    F(:,m+1) = sign(F(:,m) + f(:,m+1)).*min(1,abs(F(:,m) + f(:,m+1)));
    J(m+1)=sum((y-F(:,m+1)).^2)/(2*Ndata);
end
